package storeroom.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;

public class Gsons {

	public static <T> T load(File f, Class<T> clazz) {
		if (f == null || !f.exists())
			return null;

		InputStreamReader isr = null;
		try {
			isr = new InputStreamReader(new FileInputStream(f),
					Charset.forName("UTF-8"));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return null;
		}

		Gson g = new GsonBuilder().create();
		return g.fromJson(isr, clazz);
	}

	public static <T> void persist(File f, T t) {
		if (t == null)
			return;
		f.getParentFile().mkdirs();

		try {
			f.createNewFile();
			OutputStreamWriter osw = new OutputStreamWriter(
					new FileOutputStream(f), Charset.forName("UTF-8"));
			Gson g = new GsonBuilder().setPrettyPrinting().create();
			g.toJson(t, osw);

			osw.flush();
			osw.close();
		} catch (JsonIOException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
