package storeroom.util;

public class EndianUtil {

	public static byte[] intToByteArrL(int value) {
		byte[] arr = new byte[4];
		arr[0] = (byte) (value & 0xFF);
		arr[1] = (byte) (value >> 8 & 0xFF);
		arr[2] = (byte) (value >> 16 & 0xFF);
		arr[3] = (byte) (value >> 24 & 0xFF);

		return arr;

	}

	public static int ByteArrToIntL(byte[] arr) {
		int b0 = arr[0] & 0xff;
		int b1 = (arr[1] & 0xff) << 8;
		int b2 = (arr[2] & 0xff) << 16;
		int b3 = (arr[3] & 0xff) << 24;
		return b3 | b2 | b1 | b0;
	}

	public static final int nextIntL(byte[] b, int p) {
		int b0 = b[p++] & 0xff;
		int b1 = (b[p++] & 0xff) << 8;
		int b2 = (b[p++] & 0xff) << 16;
		int b3 = (b[p] & 0xff) << 24;
		return b3 | b2 | b1 | b0;
	}

}
