package storeroom.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {

	private static SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddkkmmss");// _kkmmss
	public static SimpleDateFormat sf2 = new SimpleDateFormat("yyMMdd_kkmmss");
	public static SimpleDateFormat timeFmt = new SimpleDateFormat("kk:mm:ss");
	public static SimpleDateFormat dateFmt = new SimpleDateFormat("MM.dd.yyyy");

	public static Date StrToDate(String dateStr) throws ParseException {
		return sf.parse(dateStr);// ("yyyy-MM-dd kk:mm:ss");

	}

	public static String dateToStr(Date date) {
		// return DateFormat.format("yyyyMMdd", date).toString();
		return sf.format(date);
	}

	public static Date nextDate(Date init, int interval) {
		if (init != null && interval > 0) {
			Calendar c = Calendar.getInstance();
			Date tmp = c.getTime();

			// init.setSeconds(init.getSeconds() + interval);
			c.setTime(init);
			int mCurrentSecond = c.get(Calendar.SECOND);
			c.set(Calendar.SECOND, mCurrentSecond + interval);
			Date nextDate = c.getTime();

			c.setTime(tmp);
			return nextDate;
		} else
			return null;

	}

	public static String getFormateTime(Date date) {
		return timeFmt.format(date);
	}

	public static String getFormateDate(Date date) {
		return dateFmt.format(date);
	}
	// public static String getFormateTime(long currentTimeMillis) {
	// return (String) DateFormat.format("kk:mm:ss", currentTimeMillis);
	// }
	//
	// public static String getFormateDate(long currentTimeMillis) {
	// return (String) DateFormat.format("MM.dd.yyyy", currentTimeMillis);
	// }
}
