package storeroom.util;

import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;

/**
 * TimeMeasure，计时器
 * 
 */
public class CTimer {

	long startT;
	long stopT;

	/**
	 * 计时开始
	 */
	public void start() {
		startT = Calendar.getInstance().getTimeInMillis();
	}

	/**
	 * 计时结束
	 */
	public void stop() {
		stopT = Calendar.getInstance().getTimeInMillis();
	}

	/**
	 * 计算时间差，毫秒为单位
	 * 
	 * @return
	 */
	public long measure() {
		return stopT - startT;
	}

	/**
	 * 计算时间差，秒为单位
	 * 
	 * @return
	 */
	public long measureInSecond() {
		return measure() / 1000;
	}

	Timer timer = new Timer();

	/**
	 * 延迟毫秒后开始执行runnable
	 */
	public void delayRun(final Runnable r, int delayTime) {
		timer.schedule(new TimerTask() {
			public void run() {

				new Thread(r).start();
				timer.cancel();
			}
		}, delayTime);
	}

}