package storeroom.util;

import java.io.IOException;
import java.io.InputStream;

public class ByteUtil {

	public ByteUtil() {
	}

	public static short twoBytesToShort(byte high, byte low) {
		return (short) (((high & 0x00ff) << 8) | (low & 0x00ff));
	}

	public static String toMacAddress(byte[] arr) {
		StringBuilder sb = new StringBuilder();
		for (int i = 0, len = arr.length; i < len; i++) {
			if (i < len - 1)
				sb.append(String.format("%02X", arr[i]) + ":");
			else
				sb.append(String.format("%02X", arr[i]));
		}
		return sb.toString();
	}

	@Deprecated
	public static String toMacAddress_LEndian(byte[] arr) {
		StringBuilder sb = new StringBuilder();
		for (int i = arr.length - 1; i >= 0; i--) {
			if (i > 0)
				sb.append(String.format("%02X", arr[i]) + ":");
			else
				sb.append(String.format("%02X", arr[i]));
		}
		return sb.toString();
	}

	public static String getBytesHexStr(byte[] buf) {
		StringBuilder sb = new StringBuilder();

		for (int i = 0; i < buf.length; i++) {

			sb.append(String.format("%02x ", buf[i]));
			if ((i + 1) % 16 == 0)
				sb.append("\n");
		}
		return sb.toString();
	};
	
	/**
	 * @return buf
	 * @throws IOException
	 */
	public static byte[] readInputStreamToBuf(InputStream inputStream) throws IOException {
		int readlen = 0;
		byte[] tmp = new byte[200];// TODO 不用循环new 更高效
		// StringBuilder sb = new StringBuilder();
		/* 从线路上读取数据流 */
		while (inputStream.available() > 0) {
			int numBytes = inputStream.read(tmp);
			readlen += numBytes;
		}
		// System.out.println("readlen:" + readlen);

		byte[] buf = new byte[readlen];
		for (int i = 0; i < readlen; i++) {
			buf[i] = tmp[i];

			// sb.append(String.format("%02x ", tmp[i]));
			// if ((i + 1) % 16 == 0)
			// sb.append("\n");
		}
		return buf;
	}

}
