package model.offlineRec;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import frame.i18n.R;
import frame.i18n.StringRes;

import storeroom.util.ByteUtil;
import storeroom.util.DateUtil;
import storeroom.util.EndianUtil;
import storeroom.util.FuncUnit;
import storeroom.util.RateUnit;
import storeroom.util.SPool;

import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.MultimeterClient;
import model.MultimeterReceivedData;

public class OfflineDataModelVariant {
	private static final int FLASH_ONE_DATA_LENGTH = 2;
	private static final int ERROR_NONE = 0;
	// private Context mContext;
	// private MultimeterClient mClient;
	private List<MultimeterReceivedData> sFlashDataList;
	private ArrayList<Byte> mValidDataBuf;
	private BleAgent ag;

	public OfflineDataModelVariant(MultimeterClient mClient) {
		// this.mClient = mClient;
		// this.mContext = mContext;
		sFlashDataList = new ArrayList<MultimeterReceivedData>();
		mValidDataBuf = new ArrayList<Byte>();

		ag = Platform.getBle();

	}

	private File sSavedFile;
	private String sSavedFileName = "";
	private byte[] mDataLeft_flash;
	private int mDataLeftLength_flash = 0;

	private int mMarkCount = 0;
	private boolean lastGetting = false, onGetting = false, onMark = false;
	private short mGear = (short) 0xF000;// 0xF020
	private String modeString = "FLM", funcString = "FLF", unitString = "FLU";

	private Date mStartOfflineRecTime;
	private int mOfflineRecInterval = 0;

	public void handleData(MultimeterClient client, byte[] data, int datalength,boolean is55) {
		if (client == null || data == null || datalength <= 0) {
			MSG_ERROR("handleReceivedData, Invalid argument");
			return;
		}
		// dumpData(data, datalength);
		int leftlength = mDataLeftLength_flash + datalength;
		ByteBuffer buffer = ByteBuffer.allocate(leftlength);
		if (mDataLeftLength_flash > 0 && mDataLeft_flash != null) {
			buffer.put(mDataLeft_flash);
		}
		buffer.put(data, 0, datalength);

		byte[] tmp = buffer.array();
		//System.out.println("handle temp arr["+leftlength+"]:");
		//for (byte b : tmp) {
		//	System.out.print("," + b);
		//}
		//System.out.println();

		int i = 0;
		int result = ERROR_NONE;
		while (leftlength >= FLASH_ONE_DATA_LENGTH) {
			byte low = tmp[i++];
			byte high = tmp[i++];
			leftlength -= FLASH_ONE_DATA_LENGTH;

			lastGetting = onGetting;
			onMark = (low & 0xff) == 0xff && (high & 0xff) == 0xff;
			if (onMark && !onGetting) {
				mMarkCount++;
				onGetting = mMarkCount == 10;
				MSG_DEBUG("enter.nowMark:" + onMark + ",c:" + mMarkCount);
			} else if (onMark && onGetting) {
				mMarkCount--;
				onGetting = mMarkCount > 0;
				MSG_DEBUG("leave.nowMark:" + onMark + ",c:" + mMarkCount);
			}

			/* 得到头尾标记内有用的数据体 */
			if (onGetting && !onMark) {
				acceptValidFlashDatas(low, high);
				// acceptNParseFlashDatas(low, high);
			}
			/* 上时刻的status为真,此刻onGetting为假,说明取数据结束 */
			if (lastGetting && !onGetting) {
				doEndJob(is55);
			}
		}
		/** 若后面频繁调试,可以分布各result到各处，最后打印result确定出错位置 */
		if (result != ERROR_NONE) {
			MSG_ERROR("handleReceivedData, Parse received data fail, result = "
					+ result);
			return;
		}

		if (leftlength > 0) {
			// MSG_ERROR("handleReceivedData, " + leftlength + " bytes left");
			ByteBuffer temp = ByteBuffer.allocate(leftlength);
			temp.put(tmp, i, leftlength);

			mDataLeft_flash = temp.array();
			mDataLeftLength_flash = leftlength;
		} else {
			mDataLeft_flash = null;
			mDataLeftLength_flash = 0;
		}
		return;
	}

	int readbytescount = 0;

	void acceptValidFlashDatas(byte low, byte high) {
		mValidDataBuf.add(low);
		mValidDataBuf.add(high);
		// MSG_DEBUG(",(" + readbytescount++ + ")H:" + String.format("%02X",
		// low)
		// + ",(" + readbytescount++ + ")L:" + String.format("%02X", high));

		Platform.getBle().broadcast.sendBroadcast_OfflineTransmitProgress(null,
				FLASH_ONE_DATA_LENGTH);
		// Intent intent = new Intent(SPool.ACTION_READ_PROGRESS_VALUE);
		// intent.putExtra(SPool.EXTRA_READ_PROGRESS_VALUE,
		// FLASH_ONE_DATA_LENGTH);
		// mContext.sendBroadcast(intent);
	}

	void doEndJob(boolean is55) {
		LenPt = 0;
		BleClient mClient = ag.getClient();
		mClient.setTransmitState(MultimeterClient.STATE_TRANSMIT_REAL_TIME);

		parseFlashDatas(is55);
		File f = saveFlashDatasAfterParsed(mClient);

		MSG_INFO("@Flash data transmit over ,send broadcast to saveData");
		ag.broadcast.sendBroadcast_OfflineTransmitEnd(false,
				f.getAbsolutePath());
		// Intent intent = new Intent(SPool.ACTION_READ_PROGRESS_END_TOSAVE);
		// mContext.sendBroadcast(intent);
		readbytescount = 0;
		mMarkCount = 0;
	}

	void parseFlashDatas(boolean is55) {
		if (mValidDataBuf == null || mValidDataBuf.size() == 0) {
			return;
		}
		MSG_INFO("@ParseFlashDatas");
		int p = 0;
		int size = mValidDataBuf.size();
		byte[] arr = new byte[size];
		for (; p < size; p++) {
			arr[p] = mValidDataBuf.get(p);
		}
		p = 0;

		BleClient mClient = ag.getClient();
		boolean onDate = mClient.getBleSeries().isSurportOfflineDate();
		if (onDate) {
			// 获取开始记录的时间和间隔
			mStartOfflineRecTime = parseDate(arr, p);
			// MSG_ERROR("&&&&&&&&&&&&mStartOfflineRecTime:"
			// + DateUtil.dateToStr(mStartOfflineRecTime));
			p += 8;
			mOfflineRecInterval = parseInterval(arr, p);
			p += 4;
			// MSG_ERROR("&&&&&&&&&&&&Interval:" + mOfflineRecInterval);

		}
		// 获取长度
		int len = EndianUtil.nextIntL(arr, p);
		p += 4;
		MSG_DEBUG("###OfflineReceivedDataLen:" + len);
		// TODO

		// 解析档位和数据值
		int idx = 0;
		for (; p + 1 < size;) {
			byte low = arr[p++];
			byte high = arr[p++];
			parseOneUnit(low, high, idx++,is55);
		}
		mValidDataBuf.clear();
		MSG_DEBUG("###After parse mValidDataBuf size is:"
				+ mValidDataBuf.size());
	}

	private void parseOneUnit(byte low, byte high, int idx,boolean is55) {
		// ,byte[] tmp, int i
		double DATA = 0;
		boolean isGears = (!is55 && (high & 0xfc) == 0xf0) || (is55 && (high & 0xf8) == 0xf0);
		
		if (isGears) {//(high & 0xfc) == 0xf0
			// MSG_DEBUG("##### In Gear:");
			String rate;
			// 单位0x03C0 >>6, 倍率0x38 >>3, 小数点位置0x7
			mGear = ByteUtil.twoBytesToShort(high, low);

			// 倍率
			switch ((mGear & 0x0038) >> 3) {
			case 0:// p=0x0
				rate = RateUnit.p.toString();// "p";
				break;
			case 1:// n=0x1、
				rate = RateUnit.n.toString();// "n";
				break;
			case 2:// u=0x2、
				rate = RateUnit.u.toString();// "u";
				break;
			case 3:// m=0x3、
				rate = RateUnit.m.toString();// "m";
				break;
			case 4:// -=0x4、
				rate = RateUnit.None.toString(); // "";
				break;
			case 5:// K=0x5、
				rate = RateUnit.K.toString();// "K";
				break;
			case 6:// M=0x6、
				rate = RateUnit.M.toString();// "M";
				break;
			case 7:// G=0x7、
				rate = RateUnit.G.toString();// "G";
				break;
			default:
				// ERROR
				rate = "?";
				break;
			}

			// 单位
			switch ((mGear & 0x03C0) >> 6) {
			case 0:// DCV=0x0、
				funcString = FuncUnit.DC.toString();// "DC";
				unitString = rate + StringRes.getString(R.unit_volt);
				break;
			case 1:// ACV=0x1、
				funcString = FuncUnit.AC.toString();// "AC";
				unitString = rate + StringRes.getString(R.unit_volt);
				break;
			case 2:// DCA=0x2、
				funcString = FuncUnit.DC.toString();// "DC";
				unitString = rate + StringRes.getString(R.unit_ampere);
				break;
			case 3:// ACA=0x3、
				funcString = FuncUnit.AC.toString();// "AC";
				unitString = rate + StringRes.getString(R.unit_ampere);
				break;
			case 4:// Ω=0x4、
				funcString = FuncUnit.OHM.toString();
				unitString = rate + StringRes.getString(R.unit_ohm);
				break;
			case 5:// F=0x5、
				funcString = FuncUnit.F.toString();
				unitString = rate + StringRes.getString(R.unit_farad);
				break;
			case 6:// Hz=0x6、
				funcString = FuncUnit.Hz.toString();
				unitString = rate + StringRes.getString(R.unit_Hz);
				break;
			case 7:// %=0x7、
				funcString = FuncUnit.Percent.toString();
				unitString = StringRes.getString(R.unit_percent);
				break;
			case 8:// ℃=0x8、
				funcString = FuncUnit.Centigrade.toString();
				unitString = rate + StringRes.getString(R.unit_centigrade);
				break;
			case 9:// ℉=0x9、
				funcString = FuncUnit.Fahrenheit.toString();
				unitString = rate + StringRes.getString(R.unit_fahrenheit);
				break;
			case 10:// Diode=0xA、
				funcString = FuncUnit.Diode.toString();
				unitString = rate + StringRes.getString(R.unit_volt);
				break;
			case 11:// Continuity=0xB、
				funcString = FuncUnit.Continuity.toString();
				unitString = rate + StringRes.getString(R.unit_ohm);
				break;
			case 12:// hFE=0xC、
				funcString = unitString = FuncUnit.HFEC.toString();// "hFE";
				break;
			case 13:// ADP=0xD、
				funcString = unitString = FuncUnit.ADP.toString();// "ADP";
				break;
			default:// ERROR
				funcString = unitString = "?";
				break;
			}

		} else {

			String point = "?";
			short oneData = ByteUtil.twoBytesToShort(high, low);
			
			boolean negative;
            if (!is55) {
                negative = (high >> 7) != 0;// 正负号位从bit15移动到bit0,(1负,0正)
				DATA = oneData & 0x7FFF;
            }else{
				negative = ((mGear >> 10) & 1) != 0;// 正负号位从bit15移动到bit0,(1负,0正)
				DATA = oneData;
			}
			
			
			
			// 小数点
			switch (mGear & 0x0007) {
			case 0:
				point = "00000";
				break;
			case 1:
				DATA /= 10;
				point = "0000.0";
				break;
			case 2:
				DATA /= 100;
				point = "000.00";
				break;
			case 3:
				DATA /= 1000;
				point = "00.000";
				break;
			case 4:
				DATA /= 10000;
				point = "0.0000";
				break;
			case 6:
				point = "UL";
				break;
			case 7:
				point = "OL";
				break;
			default:
				point = "?";
				break;
			}

			boolean isU_O = point.equals("UL") || point.equals("OL");

			if (negative) {
				DATA = -DATA;
			}
			String DataString = isU_O ? point : (String.valueOf(DATA));

			MultimeterReceivedData receivedData = new MultimeterReceivedData();

			// ByteBuffer source = ByteBuffer.allocate(FLASH_ONE_DATA_LENGTH);
			// source.put(tmp, i - FLASH_ONE_DATA_LENGTH,
			// FLASH_ONE_DATA_LENGTH);
			// receivedData.SourceData = source.array();
			receivedData.SourceDataLength = FLASH_ONE_DATA_LENGTH;
			receivedData.Index = sFlashDataList.size();
			receivedData.Mode = modeString;
			receivedData.Func = funcString;
			receivedData.Unit = unitString;
			receivedData.ValueString = DataString;
			receivedData.Value = DATA;
			Date nextdate = DateUtil.nextDate(mStartOfflineRecTime,
					mOfflineRecInterval * idx);
			receivedData.initTime_Date(nextdate);

			// MSG_DEBUG("In number,id:" + receivedData.Index + ",Mode:"
			// + modeString + ",Func:" + funcString + ",Unit:"
			// + unitString + ",Vs:" + DataString + ",v:" + DATA);

			sFlashDataList.add(receivedData);
		}

	}

	public File saveFlashDatasAfterParsed(MultimeterClient client) {
		if (sFlashDataList == null || sFlashDataList.size() <= 0)
			return null;
		MSG_INFO("@SaveFlashDatasAfterParsed");
		String clientString = sSavedFileName;
		if (sSavedFileName == null || sSavedFileName.equals("")) {
			clientString = "";// client.getClientDeviceName();
		}

		clientString += "_"
				+ DateUtil.sf2.format(Calendar.getInstance().getTime());
		// MSG_DEBUG("saveOfflineData, DataSize: " + mFlashDataList.size());

		File file = null;
		try {
			String path = System.getProperty("user.dir");
			File sdCard = new File(path);
			sdCard = new File(sdCard, SPool.DirPath);
			// MSG_ERROR("sdCard.isExists?:" + sdCard.exists() + ",canWrite:"
			// + sdCard.canWrite());//
			if (!sdCard.exists()) {
				sdCard.mkdirs();
			}

			file = new File(sdCard, "[Offline]_" + clientString + ".xls");
			MSG_DEBUG("file.isExists?:" + file.exists() + ",can write?"
					+ file.canWrite() + "\n" + file.getAbsolutePath());

			FileOutputStream output = new FileOutputStream(file);
			OutputStreamWriter doutput = new OutputStreamWriter(output,
					"UTF-16"); // "GBK"

			for (int i = 0; i < sFlashDataList.size(); i++) {
				MultimeterReceivedData data = sFlashDataList.get(i);

				String dataString = new String(i + ",\t" + data.Func + ",\t"
						+ data.ValueString + ",\t" + data.Unit + /*",\t"
						+ data.Time + ",\t\t" + data.Date + */"\r\n");
				// output.write(dataString.getBytes());
				doutput.write(dataString);
			}
			doutput.close();
			output.close();

		} catch (FileNotFoundException e1) {
			MSG_ERROR("Create [Offline] file fail: " + clientString + ".xls ");
			return null;
		} catch (IOException e2) {
			MSG_ERROR("Write [Offline] file fail: " + clientString + ".xls ");
			return null;
		}

		clearDataList();

		sSavedFile = file;
		return file;
	}

	public void clearDataList() {
		sFlashDataList.clear();
	}

	public List<MultimeterReceivedData> getFlashDataList() {
		return sFlashDataList;
	}

	public void preSetFileName(String filename) {
		sSavedFileName = filename;
	}

	public File getFlashDataFile() {
		return sSavedFile;
	}

	private Date parseDate(byte arr[], int p) {
		String y1 = arr[p] < 10 ? ("0" + arr[p]) : String.valueOf(arr[p]);
		p++;
		String y2 = arr[p] < 10 ? ("0" + arr[p]) : String.valueOf(arr[p]);
		p++;
		String MM = arr[p] < 10 ? ("0" + arr[p]) : String.valueOf(arr[p]);
		p++;
		String dd = arr[p] < 10 ? ("0" + arr[p]) : String.valueOf(arr[p]);
		p++;
		String kk = arr[p] < 10 ? ("0" + arr[p]) : String.valueOf(arr[p]);
		p++;
		String mm = arr[p] < 10 ? ("0" + arr[p]) : String.valueOf(arr[p]);
		p++;
		String ss = arr[p] < 10 ? ("0" + arr[p]) : String.valueOf(arr[p]);
		p++;
		String dateStr = y1 + y2 + MM + dd + kk + mm + ss;

		Date day = null;
		try {
			day = DateUtil.StrToDate(dateStr);
		} catch (ParseException e) {
			return null;
		}

		return day;
	}

	private int parseInterval(byte arr[], int p) {
		int i = EndianUtil.nextIntL(arr, p);
		return i;
	}

	@Deprecated
	private byte[] LenArr = new byte[4];
	@Deprecated
	private int LenPt = 0;

	@Deprecated
	private void acceptNParseFlashDatas(byte low, byte high,boolean is55) {
		// ,byte[] tmp,int i
		// MSG_INFO("readbytes:" + readbytescount + ",high:"
		// + String.format("%02X", high) + ", low:"
		// + String.format("%02X", low));

		if (LenPt < LenArr.length) {

			LenArr[LenPt++] = low;
			LenArr[LenPt++] = high;
			// MSG_INFO("LenPt:" + LenPt);
		} else {
			if (LenPt == LenArr.length) {
				int len = LenArr[3] << 24 | LenArr[2] << 16 | LenArr[1] << 8
						| LenArr[0];
				LenPt++;
				MSG_DEBUG("$$$$$$$$$$$$$$##### LenPt:" + len);
			}

			parseOneUnit(low, high, 0,is55);
		}
		// Intent intent = new Intent(SPool.ACTION_READ_PROGRESS_VALUE);
		// intent.putExtra(SPool.EXTRA_READ_PROGRESS_VALUE,
		// FLASH_ONE_DATA_LENGTH);
		// mContext.sendBroadcast(intent);

	}

	/** Debug */
	private String TAG = "OfflineDataModelVariant";
	private static final boolean DEBUG = true;
	private static final boolean INFO = true;

	private void MSG_DEBUG(String msg) {
		if (DEBUG)
			System.out.println("dbg:" + msg);
	}

	private void MSG_ERROR(String msg) {
		System.err.println(msg);
	}

	private void MSG_INFO(String msg) {
		if (INFO)
			System.out.println("info:" + msg);
	}

}
