package model.offlineRec;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;

import model.MultimeterClient;
import model.MultimeterReceivedData;

import org.eclipse.core.internal.runtime.Log;
import org.omg.CORBA.Environment;

import storeroom.util.ByteUtil;
import storeroom.util.FuncUnit;
import storeroom.util.RateUnit;


public class OfflineDataModelUnuse {
//	private Context mContext;
	private List<MultimeterReceivedData> mFlashDataList;

	public OfflineDataModelUnuse() {//Context mContext
//		this.mContext = mContext;
		mFlashDataList = new ArrayList<MultimeterReceivedData>();
	}

	public List<MultimeterReceivedData> getFlashDataList() {
		return mFlashDataList;
	}

	private File savedFile;
	private String savedFileName = "";
	private byte[] mDataLeft_flash;
	private int mDataLeftLength_flash = 0;
	private static final int FLASH_ONE_DATA_LENGTH = 2;
	private static final int ERROR_NONE = 0;

	private byte[] LenArr = new byte[4];
	private int LenPt = 0, markCount = 0;;
	private boolean status = false, onGetting = false, onMark = false;
	private short gear = (short) 0xF000;// 0xF020
	private String ModeString = "FLM", FuncString = "FLF", unitString = "FLU";

	private int readbytescount = 0;

	public void handleData(MultimeterClient client, byte[] data, int datalength) {

		if (client == null || data == null || datalength <= 0) {
			MSG_ERROR("handleReceivedData, Invalid argument");
			return;
		}
		// readbytescount += datalength;
		// dumpData(data, datalength);

		ByteBuffer buffer = ByteBuffer.allocate(mDataLeftLength_flash
				+ datalength);

		if (mDataLeftLength_flash > 0 && mDataLeft_flash != null) {
			buffer.put(mDataLeft_flash);
		}
		buffer.put(data, 0, datalength);

		byte[] tmp = buffer.array();
		int leftlength = mDataLeftLength_flash + datalength;

		int result = ERROR_NONE;

		int i = 0;

		while (leftlength >= FLASH_ONE_DATA_LENGTH) {
			byte low = tmp[i++];
			byte high = tmp[i++];
			leftlength -= FLASH_ONE_DATA_LENGTH;

			status = onGetting;
			onMark = (low & 0xff) == 0xff && (high & 0xff) == 0xff;
			if (onMark && !onGetting) {
				MSG_INFO("nowMark:" + onMark + "，c:" + markCount);//
				markCount++;
				readbytescount = 0;
			} else if (onMark && onGetting) {
				MSG_INFO("nowMark:" + onMark + "，c:" + markCount);//
				markCount--;
			}

			if (markCount >= 10) {
				onGetting = true;
			} else if (markCount <= 0) {
				onGetting = false;
			}

			if (status && !onGetting) {
				client.setTransmitState(MultimeterClient.STATE_TRANSMIT_REAL_TIME);
				LenPt = 0;
				MSG_INFO("Flash data transmit over ,send broadcast to saveData");

//				Intent intent = new Intent(
//						SPool.ACTION_READ_PROGRESS_END_TOSAVE);
//				mContext.sendBroadcast(intent);
				saveFlashDatasAfterParsed(client);

			}

			/* 解析数据体 */
			if (onGetting && !onMark) {
				parseStruct(client, tmp, low, high, i);
			}
		}

		if (result != ERROR_NONE) {
			MSG_ERROR("handleReceivedData, Parse received data fail, result = "
					+ result);
			return;
		}

		if (leftlength > 0) {
			MSG_DEBUG("handleReceivedData, " + leftlength + " bytes left");
			ByteBuffer temp = ByteBuffer.allocate(leftlength);
			temp.put(tmp, i, leftlength);

			mDataLeft_flash = temp.array();
			mDataLeftLength_flash = leftlength;
		} else {
			mDataLeft_flash = null;
			mDataLeftLength_flash = 0;
		}

		return;

	}

	void parseStruct(MultimeterClient client, byte[] tmp, byte low, byte high,
			int i) {

		double DATA = 0;

		// MSG_INFO("readbytes:" + readbytescount + ",high:"
		// + String.format("%02X", high) + ", low:"
		// + String.format("%02X", low));

		if (LenPt < LenArr.length) {

			LenArr[LenPt++] = low;
			LenArr[LenPt++] = high;
			// MSG_INFO("LenPt:" + LenPt);
		} else {
			if (LenPt == LenArr.length) {
				int len = LenArr[3] << 24 | LenArr[2] << 16 | LenArr[1] << 8
						| LenArr[0];
				LenPt++;
				MSG_INFO("$$$$$$$$$$$$$$##### LenPt:" + len);
			}

			if ((high & 0xfc) == 0xf0) {
				MSG_INFO("$$$$$$$$$$$$$$##### In Gear:");
				String rate;
				// 单位0x03C0 >>6, 倍率0x38 >>3, 小数点位置0x7
				gear = ByteUtil.twoBytesToShort(high, low);

				// 倍率
				switch ((gear & 0x0038) >> 3) {
				case 0:// p=0x0
					rate = RateUnit.p.toString();// "p";
					break;
				case 1:// n=0x1、
					rate = RateUnit.n.toString();// "n";
					break;
				case 2:// u=0x2、
					rate = RateUnit.u.toString();// "u";
					break;
				case 3:// m=0x3、
					rate = RateUnit.m.toString();// "m";
					break;
				case 4:// -=0x4、
					rate = RateUnit.None.toString(); // "";
					break;
				case 5:// K=0x5、
					rate = RateUnit.K.toString();// "K";
					break;
				case 6:// M=0x6、
					rate = RateUnit.M.toString();// "M";
					break;
				case 7:// G=0x7、
					rate = RateUnit.G.toString();// "G";
					break;
				default:
					// ERROR
					rate = "?";
					break;
				}

				// 单位
				switch ((gear & 0x03C0) >> 6) {
				case 0:// DCV=0x0、
					FuncString = FuncUnit.DC.toString();// "DC";
//					unitString = rate + mContext.getString(R.string.unit_volt);
					break;
				case 1:// ACV=0x1、
					FuncString = FuncUnit.AC.toString();// "AC";
//					unitString = rate + mContext.getString(R.string.unit_volt);
					break;
				case 2:// DCA=0x2、
					FuncString = FuncUnit.DC.toString();// "DC";
//					unitString = rate
//							+ mContext.getString(R.string.unit_ampere);
					break;
				case 3:// ACA=0x3、
					FuncString = FuncUnit.AC.toString();// "AC";
//					unitString = rate
//							+ mContext.getString(R.string.unit_ampere);
					break;
				case 4:// Ω=0x4、
//					FuncString = mContext.getString(R.string.unit_ohm);// "Ω";
					unitString = rate + FuncString;
					break;
				case 5:// F=0x5、
					FuncString = FuncUnit.F.toString();// "F";
					unitString = rate + FuncString;
					break;
				case 6:// Hz=0x6、
					FuncString = FuncUnit.Hz.toString();// "Hz";
					unitString = rate + FuncString;
					break;
				case 7:// %=0x7、
//					FuncString = unitString = mContext
//							.getString(R.string.unit_percent);// "%";
					break;
				case 8:// ℃=0x8、
//					FuncString = unitString = mContext
//							.getString(R.string.unit_centigrade);// "℃";
					break;
				case 9:// ℉=0x9、
//					FuncString = mContext.getString(R.string.unit_fahrenheit);// "℉";
//					unitString = rate + FuncString;
					break;
				case 10:// Diode=0xA、
					FuncString = FuncUnit.Diode.toString();// "Diode";
					unitString = rate + FuncString;
					break;
				case 11:// Continuity=0xB、
					FuncString = unitString = FuncUnit.Continuity.toString();// "Continuity";
					break;
				case 12:// hFE=0xC、
					FuncString = unitString = FuncUnit.HFEC.toString();// "hFE";
					break;
				case 13:// ADP=0xD、
					FuncString = unitString = FuncUnit.ADP.toString();// "ADP";
					break;
				default:// ERROR
					FuncString = unitString = "?";
					break;
				}

			} else {

				String point = "?";
				short oneData = ByteUtil.twoBytesToShort(high, low);
				boolean negative = (high >> 7) != 0;// 正负号位从bit15移动到bit0,(1负,0正)
				DATA = oneData & 0x7FFF;
				// 小数点
				switch (gear & 0x0007) {
				case 0:
					point = "00000";
					break;
				case 1:
					DATA /= 10;
					point = "0000.0";
					break;
				case 2:
					DATA /= 100;
					point = "000.00";
					break;
				case 3:
					DATA /= 1000;
					point = "00.000";
					break;
				case 4:
					DATA /= 10000;
					point = "0.0000";
					break;
				case 6:
					point = "UL";
					break;
				case 7:
					point = "OL";
					break;
				default:
					point = "?";
					break;
				}

				boolean isU_O = point.equals("UL") || point.equals("OL");

				if (negative) {
					DATA = -DATA;
				}
				String DataString = isU_O ? point : (String.valueOf(DATA));

				MultimeterReceivedData receivedData = new MultimeterReceivedData();
				ByteBuffer source = ByteBuffer.allocate(FLASH_ONE_DATA_LENGTH);
				source.put(tmp, i - FLASH_ONE_DATA_LENGTH,
						FLASH_ONE_DATA_LENGTH);
				receivedData.SourceData = source.array();
				receivedData.SourceDataLength = FLASH_ONE_DATA_LENGTH;
				receivedData.Index = mFlashDataList.size();
				receivedData.Mode = ModeString;
				receivedData.Func = FuncString;
				receivedData.Unit = unitString;
				receivedData.ValueString = DataString;
				receivedData.Value = DATA;

				MSG_INFO("In number,id:" + receivedData.Index + ",Mode:"
						+ ModeString + ",Func:" + FuncString + ",Unit:"
						+ unitString + ",Vs:" + DataString + ",v:" + DATA);

				mFlashDataList.add(receivedData);
				// sendDataBrocast(client, receivedData);
			}
		}
		//TODO 发送广播
//		Intent intent = new Intent(SPool.ACTION_READ_PROGRESS_VALUE);
//		intent.putExtra(SPool.EXTRA_READ_PROGRESS_VALUE, FLASH_ONE_DATA_LENGTH);
//		mContext.sendBroadcast(intent);

	}

	public File saveFlashDatasAfterParsed(MultimeterClient client) {
		if (mFlashDataList == null || mFlashDataList.size() <= 0)
			return null;

		String clientString = savedFileName;
		if (savedFileName == null || savedFileName.equals("")) {
//			clientString = client.getClientDeviceName();
		}

//		clientString += "_"
//				+ DateFormat
//						.format("yyMMdd_kkmmss", System.currentTimeMillis());
		MSG_DEBUG("saveOfflineData, DataSize: " + mFlashDataList.size());

		File file = null;
		try {
			File sdCard = null;//Environment.getExternalStorageDirectory();
//			sdCard = new File(sdCard, SPool.DirPath);
			MSG_ERROR("sdCard.isExists?:" + sdCard.exists() + ",canWrite:"
					+ sdCard.canWrite());
			if (!sdCard.exists()) {
				sdCard.mkdirs();
			}

			file = new File(sdCard, "[Offline]_" + clientString + ".csv");
			MSG_INFO("file.isExists?:" + file.exists() + ",can write?"
					+ file.canWrite());

			FileOutputStream output = new FileOutputStream(file);
			OutputStreamWriter doutput = new OutputStreamWriter(output,
					"utf-16"); // "UTF-8""gb2312"

			for (int i = 0; i < mFlashDataList.size(); i++) {
				MultimeterReceivedData data = mFlashDataList.get(i);

				String dataString = new String(i + ",\t" + data.Func + ",\t"
						+ data.ValueString + ",\t" + data.Unit + "\r\n");
				// output.write(dataString.getBytes());
				doutput.write(dataString);
			}
			doutput.close();
			output.close();

		} catch (FileNotFoundException e1) {
			MSG_ERROR("Create [Offline] file fail: " + clientString + ".csv ");
			return null;
		} catch (IOException e2) {
			MSG_ERROR("Write [Offline] file fail: " + clientString + ".csv ");
			return null;
		}

		clearDataList();

		savedFile = file;
		return file;
	}

	/** 读取离线记录不用实时发送给ACTION_DATA_RECEIVED的接收器 */
	@Deprecated
//	private void sendDataBrocast(MultimeterClient client,
//			MultimeterReceivedData receivedData) {
//		Intent intent = new Intent(SPool.ACTION_DATA_RECEIVED);
//
//		intent.putExtra(SPool.EXTRA_CLIENT, client.getAddress());
//		intent.putExtra(SPool.EXTRA_DATA_INDEX, receivedData.Index);
//		intent.putExtra(SPool.EXTRA_DATA_MODE, receivedData.Mode);
//		intent.putExtra(SPool.EXTRA_DATA_FUNC, receivedData.Func);
//		intent.putExtra(SPool.EXTRA_DATA_VALUESTRING, receivedData.ValueString);
//		intent.putExtra(SPool.EXTRA_DATA_UNIT, receivedData.Unit);
//		intent.putExtra(SPool.EXTRA_DATA_VALUE, receivedData.Value);
//		intent.putExtra(SPool.EXTRA_DATA_TIME, receivedData.Time);
//
//		mContext.sendBroadcast(intent);
//	}

	public void clearDataList() {
		mFlashDataList.clear();
	}

	public void preSetFileName(String filename) {
		savedFileName = filename;

	}

	public File getFlashDataFile() {
		return savedFile;
	}

	/** Debug */
	protected String TAG = "OfflineDataModel";
	protected static final boolean Debug = false;
	protected static final boolean Info = true;

	protected void MSG_DEBUG(String msg) {
//		if (Debug)
//			Log.d(TAG, "[ Multimeter ][ " + TAG + " ] :: " + msg);

		return;
	}

	protected void MSG_ERROR(String msg) {
//		Log.e(TAG, "[ Multimeter ][ " + TAG + " ] :: Error :: " + msg);

		return;
	}

	protected void MSG_INFO(String msg) {
		// if (Info)
		// Log.i(TAG, "[ " + TAG + " ] $$$:: " + msg);
		return;
	}
}
