package model;

public class BleSeriesInfo {

	// BleSeriesDistinguish
	public static final int NONMATCH = -1, B35 = 35, B33 = 33, B41 = 41, OW18_16 = 18, OW18E = 20, OW55 = 55;;
	private int series;
	private int powerLeft;

	private byte[] firmwareVersion;
	private boolean isSupportFlashRecord;
	private boolean isSurportBattaryPost;
	private boolean isSurportRenameDevice;
	private boolean isSurportOfflineDate;
	private boolean isOnFlashRecord;
	private boolean checkIdOnce;

	public BleSeriesInfo() {
		init();
	}

	public void init() {
		byte[] b = { 0, 0, 0 };
		setSeries(NONMATCH);
		setBattaryPostSupportable(-1);
		readFirmwareVersion(b);
		setFlashRecordSupportable(false);
		setOnFlashRecordStatus(false);
	}

	public boolean isCheckIdOnce() {
		return checkIdOnce;
	}

	public void setCheckIdOnce(boolean b) {
		checkIdOnce = b;
	}

	public int getSeriesID() {
		return series;
	}

	public void setSeries(int type) {
		series = type;
	}

	public int getPowerLeft() {
		return powerLeft;
	}

	public boolean isB33() {
		return series == B33;
	}

	public boolean isB41() {
		return series == B41;
	}

	public boolean isOW18() {
		return series == OW18_16;
	}

	public boolean isOW55() {
		return series == OW55;
	}

	public boolean isOWSeries() {
		return series == OW18_16 || series == OW18E || series == OW55;
	}

	public boolean authorizedSerie() {
		// return series == NONMATCH;
		switch (series) {
		case B33:
		case B35:
		case B41:
		case OW18_16:
		case OW55:
			return true;
		default:
			return false;
		}
	}

	public void readFirmwareVersion(byte[] vs) {
		firmwareVersion = vs;
		int vsValue = vs[0] * 100 + vs[1] * 10 + vs[2];
		/** app兼容固件的列表 */
		isSurportRenameDevice = vsValue >= 11;// 从0.1.1开始支持改出厂设备名
		isSurportOfflineDate = vsValue >= 12;// 从0.1.2开始支持获取离线记录时间
	}

	public String getFirmwareVersionLabel() {
		String firmVersion = firmwareVersion[0] + "." + firmwareVersion[1] + "." + firmwareVersion[2];
		return firmVersion;
	}

	public void setFlashRecordSupportable(boolean surport) {
		this.isSupportFlashRecord = surport;
	}

	public void setBattaryPostSupportable(int powerLeft) {
		this.powerLeft = powerLeft;
		boolean supportBat = powerLeft >= 0 && powerLeft <= 100;
		isSurportBattaryPost = supportBat;
	}

	public void setOnFlashRecordStatus(boolean on) {
		this.isOnFlashRecord = on;
	}

	public boolean isSupportFlashRecord() {
		return isSupportFlashRecord;
	}

	public boolean isOnFlashRecording() {
		return isOnFlashRecord;
	}

	public boolean isSupportBattaryPost() {
		if (!isSupportFlashRecord)
			return false;
		return isSurportBattaryPost;
	}

	public boolean isSupportRenameDevice() {
		return isSurportRenameDevice;
	}

	public boolean isSurportOfflineDate() {
		return isSurportOfflineDate;
	}

	public boolean isUsingB35ChipProtocol() {
		// 目前B35仍用其芯片协议,除此之外B33和其他带离线记录功能的都用OS通用协议
		return series == B35 && !isSupportFlashRecord;
	}

}