package model;

/**
 * This abstract class is used to implement {@link BluetoothGatt} callbacks.
 */
public abstract class BleClientGattCallback {

	// /**
	// * Initialization
	// */
	// public void onInitHciState(boolean onInitSuccess) {
	//
	// }
	//
	// public void onDeviceDiscovery(boolean isDisvocerSomething,
	// String[] slaveDevs) {
	//
	// }

	// public void onServicesDiscovered(Object gatt, int status) {
	// }

	/**
	 * Interaction
	 */
	public void onConnectionStateChange(String mAddress, int newState) {
	}

	public void onCharacteristicRead(int status, byte handle, byte[] value) {
	}

	public void onCharacteristicWrite(int status, byte handle) {
	}

	public void onCharacteristicChanged(ConnHandleResult tmpConnResult,
			int status, byte[] data) {
	}

	public void onDeviceSeriesRead(int seriesId) {
	}

	/**
	 * Deprecated
	 */
	public void onDescriptorRead(Object gatt, Object descriptor, int status) {
	}

	public void onDescriptorWrite(Object gatt, Object descriptor, int status) {
	}

	public void onReliableWriteCompleted(Object gatt, int status) {
	}

	public void onReadRemoteRssi(Object gatt, int rssi, int status) {
	}
}