package kernal;

import java.util.Date;

import storeroom.util.DateUtil;
import storeroom.util.EndianUtil;



public class HexCmds {

	// "*READlen?";
	public byte[] getReadLen() {
		byte[] readLen = { 0x2A, 0x52, 0x45, 0x41, 0x44, 0x6c, 0x65, 0x6e,
				0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
		return readLen;
	}

	// "*READ?"
	public byte[] getReadCmd() {
		byte[] read = { 0x2A, 0x52, 0x45, 0x41, 0x44, 0x3F, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
		return read;
	}

	// "*READ1?"
	public byte[] getRead1Cmd() {
		byte[] read = { '*', 'R', 'E', 'A', 'D', '1', '?', 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
		// 2A 52 45 41 44 31 3F 00 00 00 00 00 00 00 00 00
		return read;
	}

	public byte[] getDateCmd() {
		byte[] dateCmd = { '*', 'D', 'A', 'T', 'e', 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

		String sdate = DateUtil.dateToStr(new Date());
		for (int p = 0; p < 7; p++) {
			String s = sdate.substring(p << 1, (p << 1) + 2);
			dateCmd[p + 5] = Byte.parseByte(s);
		}
		return dateCmd;
	}

	// *RECOrd,interval+length
	public byte[] getRecordCmd(int iv, int ln) {

		byte[] order = { 0x2A, 0x52, 0x45, 0x43, 0x4f, 0x72, 0x64, 0x2C };
		byte[] interval = EndianUtil.intToByteArrL(iv);
		byte[] length = EndianUtil.intToByteArrL(ln);

		int cmdsLen = order.length + interval.length + length.length;
		byte[] cmds = new byte[cmdsLen];
		System.arraycopy(order, 0, cmds, 0, order.length);
		System.arraycopy(interval, 0, cmds, order.length, interval.length);
		System.arraycopy(length, 0, cmds, order.length + interval.length,
				length.length);
		return cmds;
	}

	public byte[] getStopRecordCmd() {
		byte[] order = { 0x2A, 0x53, 0x54, 0x4F, 0x50, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
		return order;
	}

	public byte[] getRenameStringBytes(String newname) {
		byte[] cmds = new byte[16];
		cmds[0] = '@';

		byte[] name = newname.getBytes();
		if (name.length > cmds.length - 1) {
			System.arraycopy(name, 0, cmds, 1, cmds.length - 1);
		} else
			System.arraycopy(name, 0, cmds, 1, name.length);

		return cmds;

	}

}
