package kernal;

import java.io.UnsupportedEncodingException;

import main.Platform;
import model.ConnHandleResult;
import model.DiscoverResult;

public class Event {
	// Event
	public static final int GAP_HCI_ExtentionCommandStatus = 0x067F;// 1663
	public static final int GAP_DeviceInitDone = 0x0600;// 1536
	public static final int GAP_DeviceInformation = 0x060D;// 1549
	public static final int GAP_DeviceDiscoveryDone = 0x0601;// 1537

	public static final int GAP_EstablishLink = 0x0605;// 1541
	public static final int GAP_TerminateLink = 0x0606;// 1542

	public static final int ATT_HandleValueNotification = 0x051B;// 1307
	public static final int ATT_ExecuteWriteRsp = 0x0519;// 1305
	public static final int ATT_ReadRsp = 0x050B;// 1291
	public static final int ATT_WriteRsp = 0x0513;// 1299
	public static final int ATT_ReadByTypeRsp = 0x0509;// 1289
	// EventType
	public static final int EventType_Scan_Response = 0x04;
	public static final int EventType_Connectable_Undirect_Advertisement = 0x00;
	// Status
	public static final int Status_Already_Performing_That_Task = 0x11;// 17

	public static boolean sDebug = false;
	public static boolean onDebugHead = false;
	public static boolean onDebugDump = false;
	public static boolean onDebugNotification = false;

	public static int name(byte b1, byte b2) {
		return toShort(b1, b2);
	}

	public static int toShort(byte b1, byte b2) {
		final int low = b1 & 0xFFFF;
		final int high = (b2 << 8) & 0xFFFF;
		return high | low;
	}

	// OpCode
	public static final int GAP_EstablishLinkRequest = 0xFE09;
	// Status
	public static final int Success = 0x00;

	public static boolean GAP_HCI_ExtentionCommandStatus_handle(byte[] buf, int p, int structLen) {
		if (buf.length != structLen + 3) {
			System.err.println("Event.GAP_HCI_ExtentionCommandStatus_handle.bufLen Error\nbufLen:" + buf.length
					+ ",structLen:" + structLen);
		}
		int status = buf[p++];
		int opCode = toShort(buf[p++], buf[p++]);
		int dataLength = buf[p++];
		/** do handle */
		if (status == Status_Already_Performing_That_Task) {
			// TODO sendBroadcast_AlreadyPerformingThatTask
			Platform.getBle().broadcast.sendBroadcast_AlreadyPerformingThatTask(null, status);
		}
		/** println */
		println(" Event\t\t: 0x067F (1663) (GAP_HCI_ExtentionCommandStatus)");
		println2x(" Status\t\t: ", status);// 0x00 (0) (Success)
		println4x(" OpCode\t\t: ", opCode);// 0xFE31 (GAP_GetParam)
		println2x(" DataLength\t: ", dataLength);// 0x00 (0)

		if (dataLength > 0) {
			int paramValue = toShort(buf[p++], buf[p++]);
			println4x(" ParamValue\t: ", paramValue);
		}

		return status == Success;
	}

	public static byte[] ATT_HandleValueNotification_handle(byte[] buf, int p, int structLen,
			ConnHandleResult tmpResult) {
		int status = buf[p++];

		tmpResult.setResult(buf[p++], buf[p++], null);
		int connHandle = tmpResult.ConnID;// 0x0000 (0)
		int pduLen = buf[p++];// 0x08 (8)
		int handle = toShort(buf[p++], buf[p++]);// 0x002E (46)
		byte[] value = new byte[pduLen - 2];// 19:F0:04:00:BD:09
		System.arraycopy(buf, p, value, 0, value.length);

		/** println */
		if (onDebugNotification) {
			println(" Event\t: 0x051B (1307) (ATT_HandleValueNotification)");
			println2x(" Status\t\t:", status);
			println4x(" ConnHandle\t:", connHandle);
			println2x(" PduLen\t\t:", pduLen);
			println4x(" Handle\t\t:", handle);
			println2xLink(" Value\t\t:  ", value);
		}

		// System.out.print(" Value,size:" + value.length + "\t\t: ");
		// for (int i = 0, len = value.length; i < len; i++) {
		// if (i < len - 1)
		// System.out.print(String.format("%02X", value[i]) + ":");
		// else
		// System.out.print(String.format("%02X", value[i]) + "\n\n");
		// }

		if (status != Success)
			return null;
		return value;
	}

	// Event : 0x0600 (1536) (GAP_DeviceInitDone)
	// Status : 0x00 (0) (Success)
	// DevAddr : 78:A5:04:77:F6:2C
	// DataPktLen : 0x001B (27)
	// NumDataPkts : 0x04 (4)
	// IRK : 9E:2F:FE:A9:60:81:3D:AB:BC:51:74:B2:08:E4:73:45
	// CSRK : 53:C0:B2:BF:34:B4:DC:D4:0A:1A:33:46:EC:97:95:CE
	public static boolean GAP_DeviceInitDone_handle(byte[] buf, int p, int structLen) {
		int status = buf[p++];
		byte[] devAddr = new byte[6];// 78:A5:04:77:F6:2C
		for (int i = devAddr.length - 1; i >= 0; i--) {
			devAddr[i] = buf[p++];
		}
		int dataPktLen = toShort(buf[p++], buf[p++]);
		byte numDataPkts = buf[p++];

		byte[] IRK = new byte[16];
		byte[] CSRK = new byte[16];
		System.arraycopy(buf, p, IRK, 0, IRK.length);
		System.arraycopy(buf, p += IRK.length, CSRK, 0, structLen - p - 1);

		/** println */
		println(" Event\t\t:  0x0600 (1536) (GAP_DeviceInitDone)");
		println2x(" Status\t\t:  ", status);
		println2xLink(" DevAddr\t:  ", devAddr);
		// System.out.print(" DevAddr\t\t: ");
		// for (int i = 0, len = devAddr.length; i < len; i++) {
		// if (i < len - 1)
		// System.out.print(String.format("%02X", devAddr[i]) + ":");
		// else
		// System.out.print(String.format("%02X", devAddr[i]) + "\n\n");
		// }
		println4x(" DataPktLen\t:  ", dataPktLen);
		println2x(" NumDataPkts\t:  ", numDataPkts);
		println2xLink(" IRK\t\t:  ", IRK);
		println2xLink(" CSRK\t\t:  ", CSRK);

		return status == Success;
	}

	// Event : 0x060D (1549) (GAP_DeviceInformation)
	// Status : 0x00 (0) (Success)
	// EventType : 0x00 (0) (Connectable Undirect Advertisement)
	// AddrType : 0x00 (0) (Public)
	// Addr : 7C:EC:79:45:C4:00
	// Rssi : 0xB8 (184)
	// DataLength : 0x03 (3)
	// Data : 02:01:06
	public static boolean GAP_DeviceInformation_handle(byte[] buf, int p, int structLen) {
		int status = buf[p++];
		int eventType = buf[p++];
		int addrType = buf[p++];
		byte[] addr = new byte[6];
		for (int i = 0, len = addr.length; i < len; i++) {
			addr[i] = buf[p++];
			// System.err.print(String.format("%02X", addr[i]) + ":");
		}
		// System.err.println();

		byte rssi = buf[p++];
		int dataLength = buf[p++];
		byte[] data = new byte[dataLength];
		for (int i = 0; i < data.length; i++) {
			if (p < structLen + 3)
				data[i] = buf[p++];
		}
		/** do handle */
		DiscoverResult r = new DiscoverResult();
		if (status == 0) {// && eventType == EventType_Scan_Response
							// &&success==0
			r.addr = addr;
			for (int i = addr.length - 1; i >= 0; i--) {
				r.addrName += String.format("%02X", addr[i]);
				if (i != 0)
					r.addrName += ":";
			}
			r.rssi = rssi;
			r.devName = "";// "BDM"//"Non-connectable";

			Platform.getBle().broadcast.sendScanDeviceInfoBroadcast(null, r);
		}
		/** println */
		println(" Event\t\t: 0x060D (1549) (GAP_DeviceInformation)");
		println2x(" Status\t\t:  ", status);
		println2x(" EventType\t:  ", eventType);
		println2x(" AddrType\t:  ", addrType);
		println2xLink(" Addr\t\t:  ", addr);
		println2x(" Rssi\t\t:  ", rssi);
		println2x(" DataLength\t:  ", dataLength);
		println2xLink(" Data\t\t:  ", data);

		return status == Success;
	}

	// Event : 0x0601 (1537) (GAP_DeviceDiscoveryDone)
	// Status : 0x00 (0) (Success)
	// NumDevs : 0x02 (2)
	// Device #0
	// EventType : 0x00 (0) (Connectable Undirect Advertisement)
	// AddrType : 0x00 (0) (Public)
	// Addr : 54:4A:16:5E:F1:DD
	// Device #1
	// EventType : 0x00 (0) (Connectable Undirect Advertisement)
	// AddrType : 0x00 (0) (Public)
	// Addr : 7C:EC:79:45:C4:00
	public static DiscoverResult[] GAP_DeviceDiscoveryDone_handle(byte[] buf, int p, int structLen) {

		int status = buf[p++];
		int numDevs = buf[p++];

		println(" Event\t\t: 0x0601 (1537) (GAP_DeviceDiscoveryDone)");
		println2x(" Status\t\t: ", status);
		println2x(" NumDevs\t: ", numDevs);

		DiscoverResult[] slaveAddrs = new DiscoverResult[numDevs];
		for (int idx = 0; idx < numDevs; idx++) {
			println(" Device #" + idx);
			int eventType = buf[p++];
			int addrType = buf[p++];

			byte[] addr = new byte[6];
			for (int i = 0, len = addr.length; i < len; i++) {
				addr[i] = buf[p++];
				// System.err.print(String.format("%02X", addr[i]) + ":");
			}
			// System.err.println();

			println2x(" EventType\t: ", eventType);
			println2x(" AddrType\t: ", addrType);
			println2xLink(" Addr\t: ", addr);

			// build found device address
			slaveAddrs[idx] = new DiscoverResult();
			slaveAddrs[idx].addr = addr;
			for (int i = addr.length - 1; i >= 0; i--) {
				slaveAddrs[idx].addrName += String.format("%02X", addr[i]);
				if (i != 0)
					slaveAddrs[idx].addrName += ":";
			}
		}
		if (status != Success)
			return null;
		return slaveAddrs;
	}

	// Event : 0x0605 (1541) (GAP_EstablishLink)
	// Status : 0x00 (0) (Success)
	// DevAddrType : 0x00 (0) (Public)
	// DevAddr : 54:4A:16:5E:F1:DD
	// ConnHandle : 0x0000 (0)
	// ConnRole : 0x08 (8) (Central)
	// ConnInterval : 0x0050 (80)
	// ConnLatency : 0x0000 (0)
	// ConnTimeout : 0x07D0 (2000)
	// ClockAccuracy : 0x00 (0)
	public static boolean GAP_EstablishLink_handle(byte[] buf, int p, int structLen, ConnHandleResult tmpResult) {

		int status = buf[p++];
		int devAddrType = buf[p++];

		byte[] devAddr = new byte[6];
		for (int i = devAddr.length - 1; i >= 0; i--) {
			devAddr[i] = buf[p++];
		}
		tmpResult.setResult(buf[p++], buf[p++], devAddr);
		int connHandle = tmpResult.ConnID;
		int connRole = buf[p++];
		int connInterval = toShort(buf[p++], buf[p++]);
		int connLatency = toShort(buf[p++], buf[p++]);
		int connTimeout = toShort(buf[p++], buf[p++]);

		/** println */
		println(" Event\t\t: 0x0605 (1541) (GAP_EstablishLink)");
		println2x(" Status\t\t:  ", status);
		println2x(" DevAddrType\t:  ", devAddrType);
		println2xLink(" DevAddr\t\t: ", devAddr);
		println4x(" ConnHandle\t:", connHandle);
		println2x(" ConnRole\t:  ", connRole);
		println4x(" ConnInterval\t:", connInterval);
		println4x(" ConnLatency\t:", connLatency);
		println4x(" ConnTimeout\t:", connTimeout);
		if (p < buf.length) {
			int clockAccuracy = buf[p];
			println2x(" ClockAccuracy\t\t:  ", clockAccuracy);
		}

		return status == Success;
	}

	// Event : 0x0606 (1542) (GAP_TerminateLink)
	// Status : 0x00 (0) (Success)
	// ConnHandle : 0x0000 (0)
	// Reason : 0x16 (22) (Host Requested)
	public static boolean GAP_TerminateLink_handle(byte[] buf, int p, int structLen, ConnHandleResult tmpResult) {
		int status = buf[p++];
		tmpResult.setResult(buf[p++], buf[p++], null);
		int connHandle = tmpResult.ConnID;
		// int connHandle = toShort(buf[p++], buf[p++]);
		int reason = buf[p++];

		/** println */
		println(" Event\t\t: 0x0606 (1542) (GAP_TerminateLink)");
		println2x(" Status\t\t:  ", status);
		println4x(" ConnHandle\t:", connHandle);
		println2x(" Reason\t\t:  ", reason);

		return status == Success;
	}

	// Event : 0x0519 (1305) (ATT_ExecuteWriteRsp)
	// Status : 0x00 (0) (Success)
	// ConnHandle : 0x0000 (0)
	// PduLen : 0x00 (0)
	public static boolean ATT_ExecuteWriteRsp_handle(byte[] buf, int p, int event, ConnHandleResult tmpResult) {
		int status = buf[p++];

		tmpResult.setResult(buf[p++], buf[p++], null);
		int connHandle = tmpResult.ConnID;
		int pduLen = buf[p++];

		String eventId = event == ATT_ExecuteWriteRsp ? "0x0519 (1305) (" : " 0x0513 (1299) (ATT_WriteRsp)";
		String eventStr = event == ATT_ExecuteWriteRsp ? "ATT_ExecuteWriteRsp" : "ATT_WriteRsp";

		/** println */
		println(" Event\t\t:" + eventId + eventStr + ")");
		println2x(" Status\t\t:", status);
		println4x(" ConnHandle\t:", connHandle);
		println2x(" PduLen\t\t:", pduLen);

		return status == Success;
	}

	// Event : 0x050B (1291) (ATT_ReadRsp)
	// Status : 0x00 (0) (Success)
	// ConnHandle : 0x0000 (0)
	// PduLen : 0x10 (16)
	// Value : 9B:22:2F:8C:4B:E7:DA:D2:1E:B2:A7:CC:B6:9C:6D:5F
	public static byte[] ATT_ReadRsp_handle(byte[] buf, int p, int structLen, ConnHandleResult tmpResult) {
		int status = buf[p++];
		tmpResult.setResult(buf[p++], buf[p++], null);
		int connHandle = tmpResult.ConnID;
		int pduLen = buf[p++];
		byte[] value = new byte[pduLen];
		System.arraycopy(buf, p, value, 0, pduLen);
		p += pduLen;

		/** println */
		println("Event\t\t: 0x050B (1291) (ATT_ReadRsp)");
		println2x(" Status\t\t:  ", status);
		println4x(" ConnHandle\t:", connHandle);
		println2x(" PduLen\t\t:  ", pduLen);
		println2xLink(" Value\t\t", value);

		if (status != Success)
			return null;
		return value;
	}

	// Event : 0x0509 (1289) (ATT_ReadByTypeRsp)
	// Status : 0x00 (0) (Success)
	// ConnHandle : 0x0000 (0)
	// PduLen : 0x13 (19)
	// Length : 0x12 (18)
	// Handle : 0017
	// Data : 12:63:04:00:09:00:00:00:00:00:00:00:00:00:00:00
	public static byte[] ATT_ReadByTypeRsp(byte[] buf, int p, int structLen, ConnHandleResult tmpResult) {
		int status = buf[p++];
		tmpResult.setResult(buf[p++], buf[p++], null);
		int connHandle = tmpResult.ConnID;
		int pduLen = buf[p++];
		int length = buf[p++];
		int handle = toShort(buf[p++], buf[p++]);
		byte[] data = new byte[length - 2];
		System.arraycopy(buf, p, data, 0, data.length);
		p += data.length;

		/** println */
		println("Event\t\t: 0x0509 (1289) (ATT_ReadByTypeRsp)");
		println2x(" Status\t\t:  ", status);
		println4x(" ConnHandle\t:", connHandle);
		println2x(" PduLen\t\t:  ", pduLen);
		println2x(" Length\t\t:  ", length);
		println4x(" Handle\t\t:", handle);
		println2xLink(" Value\t\t", data);

		if (status != Success)
			return null;
		return data;
	}

	public static void println(String tag) {
		if (sDebug)
			System.out.println(tag);
	}

	public static void println2x(String tag, Object value) {
		if (sDebug)
			System.out.println(tag + String.format("0x%02X", value));
	}

	public static void println4x(String tag, Object value) {
		if (sDebug)
			System.out.println(tag + String.format("0x%04X", value));
	}

	public static void println2xLink(String tag, byte[] arr) {
		if (sDebug) {
			System.out.print(tag);
			for (int i = 0, len = arr.length; i < len; i++) {
				if (i < len - 1)
					System.out.print(String.format("%02X", arr[i]) + ":");
				else
					System.out.print(String.format("%02X", arr[i]) + "\n\n");
			}
		}
	}
	
	public static String get2xLink( byte[] arr) {
		StringBuilder sb=new StringBuilder();
			for (int i = 0, len = arr.length; i < len; i++) {
				if (i < len - 1)
					sb.append(String.format("%02X", arr[i]) + ":");
				else
					sb.append(String.format("%02X", arr[i]) + "\n\n");
			}
		return sb.toString();
	}

	public static void printlnDump(int readlen, String s) {
		if (onDebugDump) {
			System.out.println("Dump(Rn):(" + readlen + ")\n" + s + "\n\n");
		}
	}

}
