package kernal;

import storeroom.util.EndianUtil;
import main.Platform;
import model.BleClientGattCallback;
import model.BleSeriesInfo;
import model.BleSlaveManager;
import model.ConnHandleResult;
import model.MultimeterClient;
import model.onRunable.OnReadRunnable;
import model.onRunable.OnWriteRunnable;

public class BleClient extends MultimeterClient {
	// private int F1_RW_HANDLE = 0X0025;
	// private int F2_R_HANDLE = 0X0028;
	// private int F3_W_HANDLE = 0X002B;
	// private int F4_NTF_HANDLE = 0X002E;

	private BleClientGattCallback bleCallback;
	private ConnHandleResult conn;
	private boolean connectStatus;

	private byte READ_HANDLE = 0;
	private byte WRITE_HANDLE = 0;
	private OnWriteRunnable onWriteRunable = null;
	private OnReadRunnable onReadRunable = null;
	private BleSeriesInfo seriesInfo;// series

	public BleClient(String address, BleClientGattCallback bleCallback) {
		super(address);
		this.bleCallback = bleCallback;
		conn = new ConnHandleResult();
		seriesInfo = new BleSeriesInfo();
		// ag = Platform.getBle();
	}

	public void setConnHandle(ConnHandleResult tmpResult) {
		// this.mConnHandle = tmpResult.getResult();
		// this.mConnID = tmpResult.ConnID;
		conn = tmpResult;
		connectStatus = true;
	}

	public ConnHandleResult getConnHandle() {
		return conn;
	}

	public int getConnID() {
		return conn.ConnID;
	}

	public BleClientGattCallback getCallback() {
		return bleCallback;
	}

	public BleSeriesInfo getBleSeries() {
		return seriesInfo;
	}

	public void onConnectionStateChange(int newState) {
		if (bleCallback != null) {
			bleCallback.onConnectionStateChange(mAddress, newState);
		}
	}

	public void onCharacteristicRead(int status, byte[] value) {// byte handle,
		if (onReadRunable != null) {
			onReadRunable.acceptParameter(status, value);
			onReadRunable.run();
			onReadRunable = null;
		}

		if (bleCallback != null) {
			bleCallback.onCharacteristicRead(status, READ_HANDLE, value);
		}
	}

	public void onCharacteristicWrite(int status) {// , byte handle
		if (onWriteRunable != null) {
			onWriteRunable.acceptParameter(status);
			onWriteRunable.run();
			onWriteRunable = null;
		}

		if (bleCallback != null) {
			bleCallback.onCharacteristicWrite(status, WRITE_HANDLE);
		}
	}

	public void onCharacteristicChanged(ConnHandleResult tmpConnResult, int status, byte[] data) {
		parseReadData(this, data);
		if (bleCallback != null) {
			bleCallback.onCharacteristicChanged(tmpConnResult, status, data);
		}

	}

	public void writeCharacteristic(byte FxFF, byte[] value) {
		WRITE_HANDLE = FxFF;
		byte[] cmds = null;
		switch (FxFF) {
		case Command.F1FF:
			byte[] handle1 = Command.getHandle(seriesInfo, FxFF);
			cmds = Command.GATT_WriteLongCharValue_handle(conn.getConnArr(), handle1, value);
			break;
		case Command.F2FF:

			break;
		case Command.F3FF:
			byte[] handle2 = Command.getHandle(seriesInfo, FxFF);
			cmds = Command.GATT_WriteCharValue_handle(conn.getConnArr(), handle2, value);
			break;
		case Command.F4FF:

			break;

		}

		Platform.getBle().writeRequest(cmds);
	};

	public void readCharacteristic(byte handle) {
		READ_HANDLE = handle;
		byte[] cmds = null;
		switch (handle) {
		case Command.F1FF:
			// cmds = Command.GATT_ReadCharValue_handle(conn.getConnArr(),
			// Command.F1_RW_HANDLE);
			cmds = Command.GATT_ReadCharValue_byUUID(conn.getConnArr(), Command.F1_RW_UUID);
			break;
		case Command.F2FF:
			// cmds = Command.GATT_ReadCharValue_handle(conn.getConnArr(),
			// Command.F2_R_HANDLE);
			cmds = Command.GATT_ReadCharValue_byUUID(conn.getConnArr(), Command.F2_R_UUID);
			break;
		case Command.F3FF:

			break;
		case Command.F4FF:

			break;

		}

		Platform.getBle().readRequest(cmds);
	};

	public void parseReadData(BleClient mClient, byte[] buf) {
		int len = buf.length;
		// System.err.println("是否进入离线传输模式？"+isOnFlashTransmit());
		// for(byte b:buf ){
		// System.err.print(","+b);
		// }
		// System.err.println();
		if (isOnFlashTransmit()) {
			if (seriesInfo.isOW55()) {
				handleReceivedData_flash55(mClient, buf, len);
				System.err.println("seriesInfo.isOW55");
			} else {
				handleReceivedData_flash2(mClient, buf, len);
			}
		} else {
			
			handleReceivedData_common(mClient, buf, len,seriesInfo.isOW55());
		}
	};

	public boolean isConnected() {
		return connectStatus;
	};

	public void disconnect() {
		connectStatus = false;
		bleCallback = null;
		Platform.getBle().terminateLinkRequest(conn.getConnArr());
	};

	public void writeCmd_GetOfflineDataSize() {
		byte[] value = new HexCmds().getReadLen();
		writeCharacteristic(Command.F1FF, value);
		onWriteRunable = new OnWriteRunnable() {
			@Override
			public void run() {
				// System.err.println("###writeCmd_GetOfflineDataSize status
				// (success 2),(err 3):"+status);
				if (status == BleAgent.STATE__SUCESS) {
					readCharacteristic(Command.F1FF);
					onReadRunable = new OnReadRunnable() {
						@Override
						public void run() {
							if (status == BleAgent.STATE__SUCESS) {
								byte[] arr = value;
								int len = EndianUtil.ByteArrToIntL(arr);
								System.out.println("rn:BleClient.writeCmdNGetOfflineDataSize.offDataLen: " + len);
								Platform.getBle().broadcast.sendBroadcast_OfflineDataSize(null, len);
							}
						}
					};
				}
			}
		};
	}

	public void readDeviceInfo() {
		readCharacteristic(Command.F2FF);
		onReadRunable = new OnReadRunnable() {
			@Override
			public void run() {
				// 机型信息:series1,power1,version3,onOfflineRecord1
				byte[] info = value;
				MSG_INFO("read char2 info# len:" + info.length);

				seriesInfo.init();
				if (info != null && info.length >= 1) {
					int seriesId = info[0];
					seriesInfo.setSeries(seriesId);
					bleCallback.onDeviceSeriesRead(seriesId);
					MSG_INFO("read info# series:" + seriesId);
				}

				if (!seriesInfo.authorizedSerie()) {
					// 提醒系列异常
					// TODO
					// failToVerify(REASON_SERIES_UNAUTHORIZE);
				}

				if (info != null && info.length >= 2) {
					// Math.abs(new Random().nextInt(99));//
					int powerLeft = info[1];

					seriesInfo.setBattaryPostSupportable(powerLeft);
					// TODO
					// Intent intent = new Intent(SPool.ACTION_BATTARY_UPDATE);
					// intent.putExtra(SPool.EXTRA_BATTARY_VALUE, powerLeft);
					// mContext.sendBroadcast(intent);
					MSG_INFO("read info# powerLeft:" + powerLeft);
				}

				// version 3byte
				if (info != null && info.length >= 5) {
					byte[] version = { info[2], info[3], info[4] };
					seriesInfo.readFirmwareVersion(version);

					MSG_INFO("read info# firmVersion:" + seriesInfo.getFirmwareVersionLabel());
					MSG_INFO("read info# offlineTime:" + seriesInfo.isSurportOfflineDate());
				}

				if (info != null && info.length >= 6) {
					switch (info[5]) {
					case -1:
						seriesInfo.setFlashRecordSupportable(false);
						break;
					case 0:
						seriesInfo.setFlashRecordSupportable(true);
						break;
					case 1:
						seriesInfo.setFlashRecordSupportable(true);
						seriesInfo.setOnFlashRecordStatus(true);
						// TODO
						// Intent intent = new
						// Intent(SPool.ACTION_NOTIFY_IN_FLASH_RECORD);
						// intent.putExtra(SPool.EXTRA_CLIENT, mAddress);
						// mContext.sendBroadcast(intent);
						break;
					}
					MSG_INFO("read info# supportFlashRecord? " + seriesInfo.isSupportFlashRecord());
				}

				if (!seriesInfo.isCheckIdOnce()) {
					seriesInfo.setCheckIdOnce(true);
					// TODO
					// sendCommand(ID_VERIFY, null);
				}
			}
		};

	}

	public void writeCmd_ReadOfflineData() {
		HexCmds lib = new HexCmds();
		boolean support = getBleSeries().isSurportOfflineDate();
		byte[] cmds = support ? lib.getRead1Cmd() : lib.getReadCmd();
		writeCharacteristic(Command.F1FF, cmds);

		onWriteRunable = new OnWriteRunnable() {
			@Override
			public void run() {
				if (status == BleAgent.STATE__SUCESS) {
					System.out.println("BleClient#writeCmd_ReadOfflineData success");
					setTransmitState(STATE_TRANSMIT_FLASH);
				} else
					System.err.println("BleClient#writeCmd_ReadOfflineData failed");
			}
		};
	}
}
