package frame;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

import control.BroadcastAgent;
import frame.i18n.R;
import frame.i18n.StringRes;

import kernal.BleAgent;
import kernal.BleClient;

import main.Platform;
import model.MultimeterClient;

public class RecordReadDialog extends JDialog implements PropertyChangeListener {

	private static RecordReadDialog readDlg;

	public static RecordReadDialog getInstance(JFrame main) {
		if (readDlg == null)
			readDlg = new RecordReadDialog(main);
		return readDlg;
	}

	JTextField fileNameLbl;
	JLabel dataLenLbl;
	JButton readBtn, openBtn;
	JProgressBar bar;
	String csvPath = "";

	private BleAgent ag;

	private RecordReadDialog(JFrame main) {
		super(main);
		setSize(new Dimension(500, 250));
		setLocationRelativeTo(null);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				readDlg = null;
			}
		});
		initDialog();

		ag = Platform.getBle();
		ag.broadcast.addProperty(this);
		BleClient mClient = ag.getClient();
		if (mClient != null) {
			mClient.writeCmd_GetOfflineDataSize();
		}
	}

	private void initDialog() {
		Container c = getContentPane();
		setLayout(new BoxLayout(c, BoxLayout.Y_AXIS));

		JPanel dataLenP = new JPanel();
		JPanel fileNameP = new JPanel();
		JPanel progressP = new JPanel();
		JPanel btnP = new JPanel();

		JLabel lbl1 = new JLabel(StringRes.getString(R.recordReadDlg_dataLen));
		// "offline data length:"
		dataLenP.add(lbl1);
		dataLenLbl = new JLabel(" xxx");
		dataLenP.add(dataLenLbl);
		JLabel unitLbl = new JLabel(StringRes.getString(R.recordReadDlg_bytes));
		// " bytes"
		dataLenP.add(unitLbl);

		JLabel lbl2 = new JLabel(StringRes.getString(R.recordReadDlg_fileName));
		// "File name for save:Offline+"
		fileNameP.add(lbl2);
		fileNameLbl = new JTextField(
				StringRes.getString(R.recordReadDlg_devName));
		// "Device Name"
		fileNameLbl.setColumns(10);
		fileNameP.add(fileNameLbl);

		bar = new JProgressBar();
		bar.setStringPainted(true);
		progressP.add(bar);

		readBtn = new JButton(StringRes.getString(R.recordReadDlg_readRec));
		// "Read Record"
		readBtn.setEnabled(false);
		btnP.add(readBtn);

		openBtn = new JButton(StringRes.getString(R.recordReadDlg_openDir));
		openBtn.setVisible(false);
		btnP.add(openBtn);

		add(dataLenP);
		add(fileNameP);
		add(progressP);
		add(btnP);

		readBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				bar.setVisible(true);
				BleClient mClient = ag.getClient();
				if (mClient != null) {
					mClient.preSetFileName(fileNameLbl.getText().trim());
					mClient.writeCmd_ReadOfflineData();
				}
			}
		});

		openBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if (csvPath != null && csvPath != "") {
					File f = new File(csvPath);
//					String dir = "cmd /c start " + f.getParent();// "hh  "
//					String dir = "hh  " + f.getAbsolutePath();
//					try {
//						Runtime.getRuntime().exec(dir);
//					} catch (IOException e1) {
//						e1.printStackTrace();
//					}
					
					
					try {
						java.awt.Desktop.getDesktop().open(f.getParentFile());
					} catch (IOException e1) {
						e1.printStackTrace();
					}
				} else {
					System.err.println("err csvPath");
				}

				// try {
				// Runtime.getRuntime().exec("cmd /c start  G:/GHOST");
				// } catch (IOException e1) {
				// e1.printStackTrace();
				// }
			}
		});

	}

	public void showDlg() {
		setVisible(true);
	}

	public static void main(String[] args) {
		new RecordReadDialog(null).showDlg();
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		String pn = evt.getPropertyName();
		Object o = evt.getNewValue();
		if (o == null)
			return;
		if (pn.equals(BroadcastAgent.BROADCAST_OFFLINEDATASIZE)) {
			int size = (Integer) o;
			dataLenLbl.setText(size + "");
			readBtn.setEnabled(true);
			bar.setMaximum(size);
		} else if (pn.equals(BroadcastAgent.BROADCAST_OFFLINEPROGRESS)) {
			int step = (Integer) o;
			int progress = bar.getValue() + step;
			int max = bar.getMaximum();
			if (progress > max) {
				progress = max;
			}
			String formatStr = StringRes
					.getString(R.recordReadDlg_progressBytes);
			bar.setString(String.format(formatStr, progress));
			bar.setValue(progress);

		} else if (pn.equals(BroadcastAgent.BROADCAST_OFFLINETRANSMITEND)) {
			csvPath = (String) o;
			openBtn.setVisible(true);
			readBtn.setVisible(false);
			// bar.setVisible(false);
			// bar.setString("receive done");
		}

	}
}
