package frame;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.BleSeriesInfo;
import model.BleSlaveManager;
import storeroom.draw.Draw;
import storeroom.util.CTimer;
import control.BroadcastAgent;
import control.DeviceInitResultListener;
import control.Global;
import control.MainControl;
import frame.i18n.R;
import frame.i18n.StringRes;
import frame.view.ChartPage;
import frame.view.MultiListItem;
import frame.view.MultiPage;
import frame.view.SinglePage;

public class MainFrame extends JFrame implements PropertyChangeListener {

	BleAgent ag;
	DeviceInitResultListener initListener;
	CTimer ti = new CTimer();

	Class mContext = MainFrame.class;

	Dimension pageSize = new Dimension(80, 40);
	Dimension funcSize = new Dimension(70, 70);
	private JPanel centerPane;
	private MultiPage mp;
	private SinglePage sp;
	private ChartPage cp;
	private ScanDialog scanDialog;
	JPanel e_btnPane, s_cmdPane;
	JButton addBtn;

	private final int ON_SINGLE = 1, ON_MULTI = 2, ON_CHART = 3;
	private CardLayout c = new CardLayout();

	private void switchPagesLayout(int pageStatus) {
		// BleClient mClient = BleSlaveManager.getSelectedClient();
		// int seriesId = BleSeriesInfo.NONMATCH;
		// if (mClient != null)
		// seriesId = mClient.getBleSeries().getSeriesID();
		// initSouthPane(seriesId);
		switch (pageStatus) {
		case ON_SINGLE:
			break;
		case ON_MULTI:
			break;
		case ON_CHART:
			cp.initChartListModel();
			cp.updateDeviceList();
			cp.updateDataList();
			break;
		}
		boolean visible = pageStatus != ON_CHART;
		e_btnPane.setVisible(visible);
		s_cmdPane.setVisible(visible);
		c.show(centerPane, String.valueOf(pageStatus));
	}

	/* 建立窗体 */
	public MainFrame() {
		super(StringRes.getString(R.title_mainFrame));
		setSize(new Dimension(850, 576));
		setLocationRelativeTo(null);
		setLayout(new BorderLayout());
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setVisible(true);

		JPanel w_btnPane = initWestPane();
		JPanel center_Pane = initCenterPane();
		initEastPane();
		initSouthPane(BleSeriesInfo.OW18_16);

		// 容器组装
		add(w_btnPane, BorderLayout.WEST);
		add(center_Pane, BorderLayout.CENTER);
		add(e_btnPane, BorderLayout.EAST);
		add(s_cmdPane, BorderLayout.SOUTH);

		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				ag.release();
				Global.saveInstance();
				// System.err.println("MainFrame windowClosing");
			}

			@Override
			public void windowClosed(WindowEvent arg0) {
				System.err.println("System.exit(0)");// MainFrame windowClosed
				System.exit(0);
			}

		});

		// addWindowStateListener(new WindowStateListener() {
		// public void windowStateChanged(WindowEvent state) {
		//
		// if (state.getNewState() == 1 || state.getNewState() == 7) {
		// System.out.println("窗口最小化");
		// } else if (state.getNewState() == 0) {
		// System.out.println("窗口恢复到初始状态");
		// } else if (state.getNewState() == 6) {
		// System.out.println("窗口最大化");
		// }
		// }
		// });
		ag = Platform.getBle();
		ag.broadcast.addProperty(this);
		initListener = new DeviceInitResultListener(this);
		new PortSettingDlg(initListener);
	}

	private JPanel initWestPane() {

		JPanel p1 = new JPanel();
		JButton btnSingle = Draw.createIconBtn(mContext, Draw.singleIcon);
		btnSingle.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				switchPagesLayout(ON_SINGLE);
			}
		});
		// p1.setBackground(Color.GREEN);
		addToCenter(p1, btnSingle);

		JPanel p2 = new JPanel();
		JButton btnMulti = Draw.createIconBtn(mContext, Draw.multiIcon);
		btnMulti.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				switchPagesLayout(ON_MULTI);
			}
		});
		// p2.setBackground(Color.YELLOW);
		addToCenter(p2, btnMulti);

		JPanel p3 = new JPanel();
		JButton btnList = Draw.createIconBtn(mContext, Draw.chartIcon);
		btnList.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				switchPagesLayout(ON_CHART);
			}
		});
		// p3.setBackground(Color.RED);
		addToCenter(p3, btnList);

		JPanel pages = new JPanel();
		pages.setLayout(new GridLayout(3, 1));
		pages.add(p1);
		pages.add(p2);
		pages.add(p3);
		return pages;
	}

	private void addToCenter(JPanel container, Component centerObj) {
		container.setLayout(new BorderLayout());
		JLabel e1 = new JLabel(" ");
		JLabel e2 = new JLabel(" ");
		e1.setPreferredSize(pageSize);
		e2.setPreferredSize(pageSize);
		// centerObj.setPreferredSize(new Dimension(80, 70));
		container.add(e1, BorderLayout.NORTH);//
		container.add(centerObj, BorderLayout.CENTER);
		container.add(e2, BorderLayout.SOUTH);//

		// container.setLayout(new FlowLayout());
		// centerObj.setPreferredSize(new Dimension(80, 70));
		// container.add(centerObj);
	}

	private JPanel initCenterPane() {

		centerPane = new JPanel();
		// JScrollPane scrollPane = new JScrollPane(centerPane);
		// scrollPane
		// .setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		// scrollPane.setBorder(null);
		// scrollPane.setOpaque(false);

		mp = new MultiPage();
		sp = new SinglePage();
		cp = new ChartPage();
		cp.setWinContext(this.getOwner());
		centerPane.setLayout(c);
		centerPane.add(mp.getContent(), String.valueOf(ON_MULTI));
		centerPane.add(sp.getContent(), String.valueOf(ON_SINGLE));
		centerPane.add(cp, String.valueOf(ON_CHART));
		// centerPane.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		// centerPane.add(new MultiListItem("1"));
		// centerPane.add(new MultiListItem("2"));
		// centerPane.add(new MultiListItem("3"));

		return centerPane;

	}

	private void initEastPane() {

		JPanel p1 = new JPanel();
		addBtn = Draw.createIconBtn(mContext, Draw.addIcon);// ("Add");
		addBtn.setEnabled(false);
		addBtn.setPreferredSize(funcSize);
		// p1.setBackground(Color.RED);
		p1.add(addBtn);
		addBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				scanDialog = ScanDialog.getInstance(MainFrame.this);
				scanDialog.showDlg();
			}
		});
		JLabel gap = new JLabel("");
		JLabel gap2 = new JLabel("");

		JPanel p2 = new JPanel();
		JButton voiceBtn = Draw.createBtn(mContext, Draw.setIcon);// ("Set");
		voiceBtn.setPreferredSize(funcSize);
		// p3.setBackground(Color.GREEN);
		p2.add(voiceBtn);

		JPanel p3 = new JPanel();
		JButton recordBtn = Draw.createBtn(mContext, Draw.readIcon);// ("Read");
		recordBtn.setPreferredSize(funcSize);
		// p4.setBackground(Color.BLUE);
		p3.add(recordBtn);

		JPanel p4 = new JPanel();
		JButton otherBtn = Draw.createIconBtn(mContext, Draw.moreIcon);// ("...");
		otherBtn.setPreferredSize(funcSize);
		// p5.setBackground(Color.CYAN);
		p4.add(otherBtn);

		JPanel p5 = new JPanel();
		JButton aboutBtn = Draw.createBtn(mContext, Draw.aboutIcon);// ("About");
		aboutBtn.setPreferredSize(funcSize);
		// p2.setBackground(Color.ORANGE);
		p5.add(aboutBtn);

		JPanel funcBtns = new JPanel();
		funcBtns.setLayout(new GridLayout(6, 1));
		funcBtns.add(p1);
		funcBtns.add(gap);
		funcBtns.add(gap2);
		funcBtns.add(p2);
		funcBtns.add(p3);
		// funcBtns.add(p4);
		funcBtns.add(p5);

		voiceBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				RecordSetDialog.getInstance(MainFrame.this).showDlg();
			}
		});

		recordBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				RecordReadDialog.getInstance(MainFrame.this).showDlg();
			}
		});

		aboutBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				// String verlbl = StringRes.getString(R.aboutDlg_ver);
				// JOptionPane.showMessageDialog(MainFrame.this, verlbl
				// + innerVersion);
				AboutDlg.getInstance(MainFrame.this).show();
			}
		});
		e_btnPane = funcBtns;
	}

	private JPanel initSouthPane_Bt() {
		JLabel e1 = new JLabel(" ");
		JButton p1 = Draw.createIconBtn(mContext, Draw.holdIcon);// ("Light/H");
		JButton p2 = Draw.createIconBtn(mContext, Draw.selectIcon);// ("Select");
		JButton p3 = Draw.createIconBtn(mContext, Draw.rangeIcon);// ("Range");
		JButton p4 = Draw.createIconBtn(mContext, Draw.dutyIcon);// ("Duty");
		JButton p5 = Draw.createIconBtn(mContext, Draw.maxIcon);// ("Max/Min");
		JButton p6 = Draw.createIconBtn(mContext, Draw.relIcon);// ("Rel/BT");
		// JButton p7 = new JButton("All");
		JLabel e2 = new JLabel(" ");

		JPanel cmdBtns = new JPanel();
		cmdBtns.setLayout(new GridLayout(1, 9));
		cmdBtns.add(e1);
		addNlistenning(cmdBtns, p1, MainControl.holdPress);
		addNlistenning(cmdBtns, p2, MainControl.selectPress);
		addNlistenning(cmdBtns, p3, MainControl.rangePress);
		addNlistenning(cmdBtns, p4, MainControl.hzPress);
		addNlistenning(cmdBtns, p5, MainControl.maxPress);
		addNlistenning(cmdBtns, p6, MainControl.relPress);
		// addNlistenning(cmdBtns, p7, MainControl.allPress);

		cmdBtns.add(e2);

		return cmdBtns;

	}

	private JPanel initSouthPane_OWSeries() {
		JLabel e1 = new JLabel(" ");
		JButton p2 = Draw.createIconBtn(mContext, Draw.selectIcon);// ("Select");
		JButton p3 = Draw.createIconBtn(mContext, Draw.rangeIcon);// ("Range");
		JButton p4 = Draw.createIconBtn(mContext, Draw.dutyIcon2);// ("Rel/Hz/Duty");
		JButton p5 = Draw.createIconBtn(mContext, Draw.holdIcon2);// ("Hold");
		JLabel e2 = new JLabel(" ");
		JPanel cmdBtns = new JPanel();
		cmdBtns.setLayout(new GridLayout(1, 6));// new
												// FlowLayout(FlowLayout.CENTER)
		cmdBtns.add(e1);
		addNlistenning(cmdBtns, p2, MainControl.selectPress);
		addNlistenning(cmdBtns, p3, MainControl.rangePress);
		addNlistenning(cmdBtns, p4, MainControl.hzPress);
		addNlistenning(cmdBtns, p5, MainControl.holdPress);
		cmdBtns.add(e2);

		return cmdBtns;
	}

	private void addNlistenning(JPanel parent, JButton btn, final int btnId) {
		btn.setPreferredSize(new Dimension(100, 55));
		parent.add(btn);
		btn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {

			}
		});
		btn.addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(MouseEvent e) {
				ti.start();
			}

			@Override
			public void mouseReleased(MouseEvent e) {
				ti.stop();
				long gap = ti.measureInSecond();
				boolean isLongPress = gap > 2;

				BleClient mClient = BleSlaveManager.getSelectedClient();
				switch (btnId) {
				case MainControl.selectPress:
				case MainControl.rangePress:
				case MainControl.holdPress:
				case MainControl.relPress:
				case MainControl.hzPress:
				case MainControl.maxPress:
					MainControl.cWriteCmd(mClient, (byte) btnId, isLongPress);
					break;
				case MainControl.allPress:
					break;
				}

			}
		});
	}

	public void initSouthPane(int seriesId) {
		if (s_cmdPane != null)
			remove(s_cmdPane);
		s_cmdPane = null;

		if (seriesId == BleSeriesInfo.OW18_16 || seriesId == BleSeriesInfo.OW18E || seriesId == BleSeriesInfo.OW55) {
			s_cmdPane = initSouthPane_OWSeries();
		} else {
			s_cmdPane = initSouthPane_Bt();
		}
		add(s_cmdPane, BorderLayout.SOUTH);
		validate();

	}

	public void addItem(MultiListItem mit, MultiListItem sit) {
		mp.add(mit.doMultiPageLayout());
		sp.add(sit.doSinglePageLayout());

		centerPane.repaint();
	}

	public void removeItem(MultiListItem mit, MultiListItem sit) {
		if (mit != null)
			mp.remove(mit);
		if (sit != null)
			sp.remove(sit);

		centerPane.repaint();
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		String pn = evt.getPropertyName();
		Object o = evt.getNewValue();
		if (o == null) {
			return;
		}

		if (pn.equals(BroadcastAgent.STATUS_DEVICE_INIT_RESULT)) {
			boolean result = (Boolean) o;
			if (result) {
				initListener.setInitResult(result);
				addBtn.setEnabled(true);
			}

		} else if (pn.equals(BroadcastAgent.STATUS_Already_Performing_That_Task)) {
			JOptionPane.showMessageDialog(MainFrame.this,
					StringRes.getString(R.scanDlg_hadConnected) + "\nSTATUS:Already Performing That Task");
		}
		// else if (pn.equals(BroadcastAgent.BROADCAST_DATA)) {
		// MultimeterReceivedData receivedData = (MultimeterReceivedData) o;
		// String value = receivedData.Index + ". " + receivedData.Func + " "
		// + receivedData.ValueString + receivedData.Unit;
		// } else if (pn.equals(BroadcastAgent.BROADCAST_INTERACTION)) {
		// String msg = (String) o;
		// } else if (pn.equals(BroadcastAgent.BROADCAST_ENABLELINK)) {
		// }
	}

}
