package frame;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import checkBLEFunc.CheckBleFrame;
import checkBLEFunc.TransmitBleDialog;
import control.Global;

import frame.i18n.R;
import frame.i18n.StringRes;

public class AboutDlg extends JDialog {
	private final String innerVersion = "20210324.9999V1.4.5_13";
	JComboBox languageCb;
	private static AboutDlg aboutDlg;

	public static AboutDlg getInstance(JFrame main) {
		if (aboutDlg == null)
			aboutDlg = new AboutDlg(main);
		return aboutDlg;
	}

	public AboutDlg(JFrame main) {
		super(main);

		setSize(new Dimension(300, 150));
		setLocationRelativeTo(null);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		// addWindowListener(new WindowAdapter() {
		// public void windowClosing(WindowEvent e) {
		// aboutDlg = null;
		// }
		// });
		initDlg(main);

	}

	private void initDlg(JFrame main) {
		Container c = getContentPane();
		setLayout(new BoxLayout(c, BoxLayout.Y_AXIS));

		JPanel localeP = new JPanel();
		JPanel versionP = new JPanel();
		JPanel checkBleP = new JPanel();
		add(localeP);
		add(versionP);
		add(checkBleP);

		JLabel localeLbl = new JLabel(StringRes.getString(R.aboutDlg_locale));
		localeP.add(localeLbl);
		languageCb = new JComboBox(Global.getInstance().localeStrs);
		localeP.add(languageCb);

		String verlbl = StringRes.getString(R.aboutDlg_ver) + innerVersion;
		JLabel versionLbl = new JLabel(verlbl);
		versionP.add(versionLbl);
		final Global g = Global.getInstance();
		languageCb.setSelectedIndex(g.getLocaleIdx());
		System.out.println("SelectedIndex:	" + g.getLocaleIdx());
		languageCb.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent arg0) {
				int idx = languageCb.getSelectedIndex();
				g.setLocale(idx);
			}
		});

		JButton getInCheckBleBtn = new JButton("CheckBLE");//
		checkBleP.add(getInCheckBleBtn);
		getInCheckBleBtn.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				TransmitBleDialog dlg = TransmitBleDialog.getInstance(main);
				dlg.toFront();
				aboutDlg.dispose();
			}
		});

	}

	public static void main(String[] args) {
		AboutDlg.getInstance(null).show();
	}
}
