package control;

import java.io.File;
import java.io.IOException;
import java.util.Locale;

import frame.i18n.R;
import frame.i18n.StringRes;

import storeroom.util.Gsons;

public class Global {
	private static Global g;

	public static Global getInstance() {
		if (g == null)
			g = load();
		return g;
	}

	private static File conf = new File("conf", "pref.json");

	private static Global load() {
		if (!conf.exists()) {
			try {
				conf.getParentFile().mkdirs();
				conf.createNewFile();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
		Global g = Gsons.load(conf, Global.class);
		return g == null ? new Global() : g;
	}

	public static void saveInstance() {
		if (g != null) {
			Gsons.persist(conf, g);
		}
	}

	public Locale locale = Locale.ENGLISH;
	public Locale[] localeList = { Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE };
	public String[] localeStrs = { "English",
			StringRes.getString(R.aboutDlg_zh_cn) };

	public Global() {
	}

	public void setDefaultLocale() {
		Locale.setDefault(locale);
		StringRes.update();
	}

	public int getLocaleIdx() {
		for (int i = 0; i < localeList.length; i++) {
			if (locale.equals(localeList[i])) {
				return i;
			}
		}
		return -1;
	}

	public void setLocale(int idx) {
		if (idx < 0 && idx > localeList.length)
			return;
		locale = localeList[idx];
	}

	public String debug() {
		String s = locale.getDisplayName();
		return s;

	}

	// public static void main(String[] args) {
	// Global g = new Global();
	// Gsons.persist(conf, g);
	// Global g2 = getSave();
	// System.out.println(g2.getLocale());
	// }

}
