package checkBLEFunc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.jfree.io.FileUtilities;

import checkBLEFunc.TransmitBleDialog.PP;
import control.MainControl;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import kernal.BleClient;
import kernal.Event;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import storeroom.util.ByteUtil;

public class TransmitBleCmdHandler implements Runnable {

	private static CommPortIdentifier portId;
	private OutputStream outputStream;
	private InputStream inputStream;
	public SerialPort serialPort;

	private Thread handler;
	public boolean onClose;
	public String address;
	PP p;

	public TransmitBleCmdHandler(String destination, PP p) {
		address = destination;
		this.p = p;
	}

	public void startTransmit(String comName) {
		/* 获取系统中所有的通讯端口 */
		Enumeration portList = CommPortIdentifier.getPortIdentifiers();
		// TODO 做成下拉框显示出来，等待用户选择一个选项。

		/* 用循环结构找出串口 */
		// TODO 把用户选中选项当索引，在循环结构中找出串口。

		while (portList.hasMoreElements()) { /* 强制转换为通讯端口类型 */
			portId = (CommPortIdentifier) portList.nextElement();
			if (portId.getPortType() == CommPortIdentifier.PORT_SERIAL) {

				if (portId.getName().equals(comName)) {
					/* 打开串口 */
					try {
						serialPort = (SerialPort) portId.open("My" + comName, 2000);
					} catch (PortInUseException e) {
						System.err.println("MyComm101 portId.open PortInUseException ");
					}
					/* 设置串口输出流 */
					try {
						outputStream = serialPort.getOutputStream();
						inputStream = serialPort.getInputStream();
					} catch (IOException e) {
						System.err.println("getOutputStream outputStream ");
					}
					break;
				} /*
					 * else System.out.println(portId.getName());
					 */
			}
		}
		// TODO 若找不到串口，停止执行
		if (serialPort == null) {
			// in_message.setText("无法找到合适端口");
			System.err.println("无法找到合适端口");
			return;
		}
		// in_message.setText(serialPort.getName() + "串口已经打开,");
		System.err.println(serialPort.getName() + "串口已经打开,");

		/* 设置串口通讯参数 */
		try {
			serialPort.setSerialPortParams(9600, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
		} catch (UnsupportedCommOperationException e) {
			System.err.println("Set UnsupportedCommOperationException ");
		}

		/* 调用线程发送数据 */
		try {
			handler = new Thread(this); // 线程负责每发送一次数据，休眠2秒钟
			handler.start();
		} catch (Exception e) {
		}
	}

	@Override
	public void run() {
		while (!onClose) {
			/*  */
			try {
				BleClient mClient = BleSlaveManager.getClient(address);// getSelectedClient();
				if (mClient != null && mClient.isConnected()) {

					byte[] buf = ByteUtil.readInputStreamToBuf(inputStream);
					String center_cmd = new String(buf);
					int size = buf.length;

					if (size > 1) {
						if (center_cmd.contains("?")) {
							// center_cmd.equalsIgnoreCase("meas?")
							// return realtime multimeter value

							List<MultimeterReceivedData> list = mClient.getReceivedData();
							MultimeterReceivedData rd = list.get(list.size() - 1);

							String rsp = rd.ValueString;
							if (center_cmd.equalsIgnoreCase("meas?"))
								rsp = rd.ValueString + rd.Unit + "\n";
							else if (center_cmd.equalsIgnoreCase("func?")) {
								rsp = rd.Func + "_" + rd.Range + "\n";
							}
							else if (center_cmd.equalsIgnoreCase("data?")) {
								rsp = Event.get2xLink(rd.SourceData) + "\n";
								System.out.println(rsp);
//								rsp = Arrays.toString(rd.SourceData) + "\n";
//								System.out.println(rsp);
							}
							outputStream.write(rsp.getBytes());
							outputStream.flush();
							// out_message.setText(rd.ValueString);
							p.updateOutput("value:  " + rsp);
							System.out.println(rsp);

						} else {
							// send cmd to low multimeter
							byte funId = -1;
							switch (center_cmd) {
							case "select":
								funId = MainControl.selectPress;
								break;
							case "range":
								funId = MainControl.rangePress;
								break;
							case "hold":
								funId = MainControl.holdPress;
								break;
							case "rel":
								funId = MainControl.relPress;
								break;
							case "hz":
								funId = MainControl.hzPress;
								break;
							case "max":
								funId = MainControl.maxPress;
								break;
							}
							// System.err.println("funId:" + funId);
							MainControl.cWriteCmd(mClient, funId, false);

							// in_message.setText(serialPort + ":" + center_cmd
							// + "
							// send");
							p.updateInput("cmd: " + center_cmd + " ");
							System.out.println("cmd:" + center_cmd + " ");
						}
					} else if (size == 1) {
						byte funId = buf[0];
						MainControl.cWriteCmd(mClient, funId, false);
						p.updateInput("send: " + funId + " ");
						System.out.println("send:" + funId + " ");

					} else {
						// in_message.setText(serialPort + ":" + center_cmd + "
						// ,can`t recognize");
						// System.out.println(serialPort + ":" + center_cmd +
						// ",can`t recognize");
					}
				} else {
					// in_message.setText(serialPort.getName() + "没有蓝牙表连接,");
					System.out.println(serialPort.getName() + "没有蓝牙表连接");
					p.updateOutput(serialPort.getName() + "没有蓝牙表连接");
				}

			} catch (IOException e) {
				e.printStackTrace();
				System.err.println("write(data) IOException ");
			}
			/* 发送数据后休眠1秒钟,然后再重发 */
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

}
