/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.provider.X509Factory;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.CRLExtensions;
import sun.security.x509.CRLNumberExtension;
import sun.security.x509.CertificateIssuerExtension;
import sun.security.x509.DeltaCRLIndicatorExtension;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.IssuerAlternativeNameExtension;
import sun.security.x509.IssuingDistributionPointExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.OIDMap;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;

public class X509CRLImpl
extends X509CRL
implements DerEncoder {
    private byte[] signedCRL = null;
    private byte[] signature = null;
    private byte[] tbsCertList = null;
    private AlgorithmId sigAlgId = null;
    private int version;
    private AlgorithmId infoSigAlgId;
    private X500Name issuer = null;
    private X500Principal issuerPrincipal = null;
    private Date thisUpdate = null;
    private Date nextUpdate = null;
    private Map<X509IssuerSerial, X509CRLEntry> revokedMap = new TreeMap<X509IssuerSerial, X509CRLEntry>();
    private List<X509CRLEntry> revokedList = new LinkedList<X509CRLEntry>();
    private CRLExtensions extensions = null;
    private static final boolean isExplicit = true;
    private static final long YR_2050 = 2524636800000L;
    private boolean readOnly = false;
    private PublicKey verifiedPublicKey;
    private String verifiedProvider;

    private X509CRLImpl() {
    }

    public X509CRLImpl(byte[] byArray) throws CRLException {
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
    }

    public X509CRLImpl(DerValue derValue) throws CRLException {
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
    }

    public X509CRLImpl(InputStream inputStream) throws CRLException {
        try {
            this.parse(new DerValue(inputStream));
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2) {
        this.issuer = x500Name;
        this.thisUpdate = date;
        this.nextUpdate = date2;
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2, X509CRLEntry[] x509CRLEntryArray) throws CRLException {
        this.issuer = x500Name;
        this.thisUpdate = date;
        this.nextUpdate = date2;
        if (x509CRLEntryArray != null) {
            X500Principal x500Principal;
            X500Principal x500Principal2 = x500Principal = this.getIssuerX500Principal();
            for (int i = 0; i < x509CRLEntryArray.length; ++i) {
                X509CRLEntryImpl x509CRLEntryImpl = (X509CRLEntryImpl)x509CRLEntryArray[i];
                try {
                    x500Principal2 = this.getCertIssuer(x509CRLEntryImpl, x500Principal2);
                }
                catch (IOException iOException) {
                    throw new CRLException(iOException);
                }
                x509CRLEntryImpl.setCertificateIssuer(x500Principal, x500Principal2);
                X509IssuerSerial x509IssuerSerial = new X509IssuerSerial(x500Principal2, x509CRLEntryImpl.getSerialNumber());
                this.revokedMap.put(x509IssuerSerial, x509CRLEntryImpl);
                this.revokedList.add(x509CRLEntryImpl);
                if (!x509CRLEntryImpl.hasExtensions()) continue;
                this.version = 1;
            }
        }
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2, X509CRLEntry[] x509CRLEntryArray, CRLExtensions cRLExtensions) throws CRLException {
        this(x500Name, date, date2, x509CRLEntryArray);
        if (cRLExtensions != null) {
            this.extensions = cRLExtensions;
            this.version = 1;
        }
    }

    public byte[] getEncodedInternal() throws CRLException {
        if (this.signedCRL == null) {
            throw new CRLException("Null CRL to encode");
        }
        return this.signedCRL;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return (byte[])this.getEncodedInternal().clone();
    }

    public void encodeInfo(OutputStream outputStream) throws CRLException {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            DerOutputStream derOutputStream3 = new DerOutputStream();
            if (this.version != 0) {
                derOutputStream.putInteger(this.version);
            }
            this.infoSigAlgId.encode(derOutputStream);
            if (this.version == 0 && this.issuer.toString() == null) {
                throw new CRLException("Null Issuer DN not allowed in v1 CRL");
            }
            this.issuer.encode(derOutputStream);
            if (this.thisUpdate.getTime() < 2524636800000L) {
                derOutputStream.putUTCTime(this.thisUpdate);
            } else {
                derOutputStream.putGeneralizedTime(this.thisUpdate);
            }
            if (this.nextUpdate != null) {
                if (this.nextUpdate.getTime() < 2524636800000L) {
                    derOutputStream.putUTCTime(this.nextUpdate);
                } else {
                    derOutputStream.putGeneralizedTime(this.nextUpdate);
                }
            }
            if (!this.revokedList.isEmpty()) {
                for (X509CRLEntry x509CRLEntry : this.revokedList) {
                    ((X509CRLEntryImpl)x509CRLEntry).encode(derOutputStream2);
                }
                derOutputStream.write((byte)48, derOutputStream2);
            }
            if (this.extensions != null) {
                this.extensions.encode(derOutputStream, true);
            }
            derOutputStream3.write((byte)48, derOutputStream);
            this.tbsCertList = derOutputStream3.toByteArray();
            outputStream.write(this.tbsCertList);
        }
        catch (IOException iOException) {
            throw new CRLException("Encoding error: " + iOException.getMessage());
        }
    }

    @Override
    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "");
    }

    @Override
    public synchronized void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (string == null) {
            string = "";
        }
        if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(publicKey) && string.equals(this.verifiedProvider)) {
            return;
        }
        if (this.signedCRL == null) {
            throw new CRLException("Uninitialized CRL");
        }
        Signature signature = null;
        signature = string.length() == 0 ? Signature.getInstance(this.sigAlgId.getName()) : Signature.getInstance(this.sigAlgId.getName(), string);
        signature.initVerify(publicKey);
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        signature.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!signature.verify(this.signature)) {
            throw new SignatureException("Signature does not match.");
        }
        this.verifiedPublicKey = publicKey;
        this.verifiedProvider = string;
    }

    @Override
    public synchronized void verify(PublicKey publicKey, Provider provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.signedCRL == null) {
            throw new CRLException("Uninitialized CRL");
        }
        Signature signature = null;
        signature = provider == null ? Signature.getInstance(this.sigAlgId.getName()) : Signature.getInstance(this.sigAlgId.getName(), provider);
        signature.initVerify(publicKey);
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        signature.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!signature.verify(this.signature)) {
            throw new SignatureException("Signature does not match.");
        }
        this.verifiedPublicKey = publicKey;
    }

    public static void verify(X509CRL x509CRL, PublicKey publicKey, Provider provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        x509CRL.verify(publicKey, provider);
    }

    public void sign(PrivateKey privateKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.sign(privateKey, string, null);
    }

    public void sign(PrivateKey privateKey, String string, String string2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            if (this.readOnly) {
                throw new CRLException("cannot over-write existing CRL");
            }
            Signature signature = null;
            signature = string2 == null || string2.length() == 0 ? Signature.getInstance(string) : Signature.getInstance(string, string2);
            signature.initSign(privateKey);
            this.infoSigAlgId = this.sigAlgId = AlgorithmId.get(signature.getAlgorithm());
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encodeInfo(derOutputStream2);
            this.sigAlgId.encode(derOutputStream2);
            signature.update(this.tbsCertList, 0, this.tbsCertList.length);
            this.signature = signature.sign();
            derOutputStream2.putBitString(this.signature);
            derOutputStream.write((byte)48, derOutputStream2);
            this.signedCRL = derOutputStream.toByteArray();
            this.readOnly = true;
        }
        catch (IOException iOException) {
            throw new CRLException("Error while encoding data: " + iOException.getMessage());
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X.509 CRL v" + (this.version + 1) + "\n");
        if (this.sigAlgId != null) {
            stringBuffer.append("Signature Algorithm: " + this.sigAlgId.toString() + ", OID=" + this.sigAlgId.getOID().toString() + "\n");
        }
        if (this.issuer != null) {
            stringBuffer.append("Issuer: " + this.issuer.toString() + "\n");
        }
        if (this.thisUpdate != null) {
            stringBuffer.append("\nThis Update: " + this.thisUpdate.toString() + "\n");
        }
        if (this.nextUpdate != null) {
            stringBuffer.append("Next Update: " + this.nextUpdate.toString() + "\n");
        }
        if (this.revokedList.isEmpty()) {
            stringBuffer.append("\nNO certificates have been revoked\n");
        } else {
            stringBuffer.append("\nRevoked Certificates: " + this.revokedList.size());
            int n = 1;
            for (X509CRLEntry x509CRLEntry : this.revokedList) {
                stringBuffer.append("\n[" + n++ + "] " + x509CRLEntry.toString());
            }
        }
        if (this.extensions != null) {
            Collection<Extension> collection = this.extensions.getAllExtensions();
            Object[] objectArray = collection.toArray();
            stringBuffer.append("\nCRL Extensions: " + objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("\n[" + (i + 1) + "]: ");
                Extension extension = (Extension)objectArray[i];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuffer.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray == null) continue;
                        DerOutputStream derOutputStream = new DerOutputStream();
                        derOutputStream.putOctetString(byArray);
                        byArray = derOutputStream.toByteArray();
                        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                        stringBuffer.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer(byArray) + "\n");
                        continue;
                    }
                    stringBuffer.append(extension.toString());
                    continue;
                }
                catch (Exception exception) {
                    stringBuffer.append(", Error parsing this extension");
                }
            }
        }
        if (this.signature != null) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            stringBuffer.append("\nSignature:\n" + hexDumpEncoder.encodeBuffer(this.signature) + "\n");
        } else {
            stringBuffer.append("NOT signed yet\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isRevoked(Certificate certificate) {
        if (this.revokedMap.isEmpty() || !(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        X509IssuerSerial x509IssuerSerial = new X509IssuerSerial(x509Certificate);
        return this.revokedMap.containsKey(x509IssuerSerial);
    }

    @Override
    public int getVersion() {
        return this.version + 1;
    }

    @Override
    public Principal getIssuerDN() {
        return this.issuer;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        if (this.issuerPrincipal == null) {
            this.issuerPrincipal = this.issuer.asX500Principal();
        }
        return this.issuerPrincipal;
    }

    @Override
    public Date getThisUpdate() {
        return new Date(this.thisUpdate.getTime());
    }

    @Override
    public Date getNextUpdate() {
        if (this.nextUpdate == null) {
            return null;
        }
        return new Date(this.nextUpdate.getTime());
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        if (this.revokedMap.isEmpty()) {
            return null;
        }
        X509IssuerSerial x509IssuerSerial = new X509IssuerSerial(this.getIssuerX500Principal(), bigInteger);
        return this.revokedMap.get(x509IssuerSerial);
    }

    @Override
    public X509CRLEntry getRevokedCertificate(X509Certificate x509Certificate) {
        if (this.revokedMap.isEmpty()) {
            return null;
        }
        X509IssuerSerial x509IssuerSerial = new X509IssuerSerial(x509Certificate);
        return this.revokedMap.get(x509IssuerSerial);
    }

    public Set<X509CRLEntry> getRevokedCertificates() {
        if (this.revokedList.isEmpty()) {
            return null;
        }
        return new TreeSet<X509CRLEntry>(this.revokedList);
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        return (byte[])this.tbsCertList.clone();
    }

    @Override
    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        return (byte[])this.signature.clone();
    }

    @Override
    public String getSigAlgName() {
        if (this.sigAlgId == null) {
            return null;
        }
        return this.sigAlgId.getName();
    }

    @Override
    public String getSigAlgOID() {
        if (this.sigAlgId == null) {
            return null;
        }
        ObjectIdentifier objectIdentifier = this.sigAlgId.getOID();
        return objectIdentifier.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.sigAlgId == null) {
            return null;
        }
        try {
            return this.sigAlgId.getEncodedParams();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public AlgorithmId getSigAlgId() {
        return this.sigAlgId;
    }

    public KeyIdentifier getAuthKeyId() throws IOException {
        AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension = this.getAuthKeyIdExtension();
        if (authorityKeyIdentifierExtension != null) {
            KeyIdentifier keyIdentifier = (KeyIdentifier)authorityKeyIdentifierExtension.get("key_id");
            return keyIdentifier;
        }
        return null;
    }

    public AuthorityKeyIdentifierExtension getAuthKeyIdExtension() throws IOException {
        Object object = this.getExtension(PKIXExtensions.AuthorityKey_Id);
        return (AuthorityKeyIdentifierExtension)object;
    }

    public CRLNumberExtension getCRLNumberExtension() throws IOException {
        Object object = this.getExtension(PKIXExtensions.CRLNumber_Id);
        return (CRLNumberExtension)object;
    }

    public BigInteger getCRLNumber() throws IOException {
        CRLNumberExtension cRLNumberExtension = this.getCRLNumberExtension();
        if (cRLNumberExtension != null) {
            BigInteger bigInteger = cRLNumberExtension.get("value");
            return bigInteger;
        }
        return null;
    }

    public DeltaCRLIndicatorExtension getDeltaCRLIndicatorExtension() throws IOException {
        Object object = this.getExtension(PKIXExtensions.DeltaCRLIndicator_Id);
        return (DeltaCRLIndicatorExtension)object;
    }

    public BigInteger getBaseCRLNumber() throws IOException {
        DeltaCRLIndicatorExtension deltaCRLIndicatorExtension = this.getDeltaCRLIndicatorExtension();
        if (deltaCRLIndicatorExtension != null) {
            BigInteger bigInteger = deltaCRLIndicatorExtension.get("value");
            return bigInteger;
        }
        return null;
    }

    public IssuerAlternativeNameExtension getIssuerAltNameExtension() throws IOException {
        Object object = this.getExtension(PKIXExtensions.IssuerAlternativeName_Id);
        return (IssuerAlternativeNameExtension)object;
    }

    public IssuingDistributionPointExtension getIssuingDistributionPointExtension() throws IOException {
        Object object = this.getExtension(PKIXExtensions.IssuingDistributionPoint_Id);
        return (IssuingDistributionPointExtension)object;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Extension extension : this.extensions.getAllExtensions()) {
            if (!extension.isCritical()) continue;
            treeSet.add(extension.getExtensionId().toString());
        }
        return treeSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Extension extension : this.extensions.getAllExtensions()) {
            if (extension.isCritical()) continue;
            treeSet.add(extension.getExtensionId().toString());
        }
        return treeSet;
    }

    @Override
    public byte[] getExtensionValue(String string) {
        if (this.extensions == null) {
            return null;
        }
        try {
            Object object;
            Object object2;
            String string2 = OIDMap.getName(new ObjectIdentifier(string));
            Object object3 = null;
            if (string2 == null) {
                object2 = new ObjectIdentifier(string);
                object = null;
                Enumeration<Extension> enumeration = this.extensions.getElements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    ObjectIdentifier objectIdentifier = ((Extension)object).getExtensionId();
                    if (!objectIdentifier.equals(object2)) continue;
                    object3 = object;
                    break;
                }
            } else {
                object3 = this.extensions.get(string2);
            }
            if (object3 == null) {
                return null;
            }
            object2 = ((Extension)object3).getExtensionValue();
            if (object2 == null) {
                return null;
            }
            object = new DerOutputStream();
            ((DerOutputStream)object).putOctetString((byte[])object2);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getExtension(ObjectIdentifier objectIdentifier) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.get(OIDMap.getName(objectIdentifier));
    }

    private void parse(DerValue derValue) throws CRLException, IOException {
        DerValue derValue2;
        AlgorithmId algorithmId;
        if (this.readOnly) {
            throw new CRLException("cannot over-write existing CRL");
        }
        if (derValue.getData() == null || derValue.tag != 48) {
            throw new CRLException("Invalid DER-encoded CRL data");
        }
        this.signedCRL = derValue.toByteArray();
        DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue(), derValue.data.getDerValue()};
        if (derValue.data.available() != 0) {
            throw new CRLException("signed overrun, bytes = " + derValue.data.available());
        }
        if (derValueArray[0].tag != 48) {
            throw new CRLException("signed CRL fields invalid");
        }
        this.sigAlgId = AlgorithmId.parse(derValueArray[1]);
        this.signature = derValueArray[2].getBitString();
        if (derValueArray[1].data.available() != 0) {
            throw new CRLException("AlgorithmId field overrun");
        }
        if (derValueArray[2].data.available() != 0) {
            throw new CRLException("Signature field overrun");
        }
        this.tbsCertList = derValueArray[0].toByteArray();
        DerInputStream derInputStream = derValueArray[0].data;
        this.version = 0;
        byte by = (byte)derInputStream.peekByte();
        if (by == 2) {
            this.version = derInputStream.getInteger();
            if (this.version != 1) {
                throw new CRLException("Invalid version");
            }
        }
        if (!(algorithmId = AlgorithmId.parse(derValue2 = derInputStream.getDerValue())).equals(this.sigAlgId)) {
            throw new CRLException("Signature algorithm mismatch");
        }
        this.infoSigAlgId = algorithmId;
        this.issuer = new X500Name(derInputStream);
        if (this.issuer.isEmpty()) {
            throw new CRLException("Empty issuer DN not allowed in X509CRLs");
        }
        by = (byte)derInputStream.peekByte();
        if (by == 23) {
            this.thisUpdate = derInputStream.getUTCTime();
        } else if (by == 24) {
            this.thisUpdate = derInputStream.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for thisUpdate (tag=" + by + ")");
        }
        if (derInputStream.available() == 0) {
            return;
        }
        by = (byte)derInputStream.peekByte();
        if (by == 23) {
            this.nextUpdate = derInputStream.getUTCTime();
        } else if (by == 24) {
            this.nextUpdate = derInputStream.getGeneralizedTime();
        }
        if (derInputStream.available() == 0) {
            return;
        }
        by = (byte)derInputStream.peekByte();
        if (by == 48 && (by & 0xC0) != 128) {
            X500Principal x500Principal;
            DerValue[] derValueArray2 = derInputStream.getSequence(4);
            X500Principal x500Principal2 = x500Principal = this.getIssuerX500Principal();
            for (int i = 0; i < derValueArray2.length; ++i) {
                X509CRLEntryImpl x509CRLEntryImpl = new X509CRLEntryImpl(derValueArray2[i]);
                x500Principal2 = this.getCertIssuer(x509CRLEntryImpl, x500Principal2);
                x509CRLEntryImpl.setCertificateIssuer(x500Principal, x500Principal2);
                X509IssuerSerial x509IssuerSerial = new X509IssuerSerial(x500Principal2, x509CRLEntryImpl.getSerialNumber());
                this.revokedMap.put(x509IssuerSerial, x509CRLEntryImpl);
                this.revokedList.add(x509CRLEntryImpl);
            }
        }
        if (derInputStream.available() == 0) {
            return;
        }
        derValue2 = derInputStream.getDerValue();
        if (derValue2.isConstructed() && derValue2.isContextSpecific((byte)0)) {
            this.extensions = new CRLExtensions(derValue2.data);
        }
        this.readOnly = true;
    }

    public static X500Principal getIssuerX500Principal(X509CRL x509CRL) {
        try {
            DerValue derValue;
            byte[] byArray = x509CRL.getEncoded();
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue derValue2 = derInputStream.getSequence(3)[0];
            DerInputStream derInputStream2 = derValue2.data;
            byte by = (byte)derInputStream2.peekByte();
            if (by == 2) {
                derValue = derInputStream2.getDerValue();
            }
            derValue = derInputStream2.getDerValue();
            derValue = derInputStream2.getDerValue();
            byte[] byArray2 = derValue.toByteArray();
            return new X500Principal(byArray2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not parse issuer", exception);
        }
    }

    public static byte[] getEncodedInternal(X509CRL x509CRL) throws CRLException {
        if (x509CRL instanceof X509CRLImpl) {
            return ((X509CRLImpl)x509CRL).getEncodedInternal();
        }
        return x509CRL.getEncoded();
    }

    public static X509CRLImpl toImpl(X509CRL x509CRL) throws CRLException {
        if (x509CRL instanceof X509CRLImpl) {
            return (X509CRLImpl)x509CRL;
        }
        return X509Factory.intern(x509CRL);
    }

    private X500Principal getCertIssuer(X509CRLEntryImpl x509CRLEntryImpl, X500Principal x500Principal) throws IOException {
        CertificateIssuerExtension certificateIssuerExtension = x509CRLEntryImpl.getCertificateIssuerExtension();
        if (certificateIssuerExtension != null) {
            GeneralNames generalNames = certificateIssuerExtension.get("issuer");
            X500Name x500Name = (X500Name)generalNames.get(0).getName();
            return x500Name.asX500Principal();
        }
        return x500Principal;
    }

    @Override
    public void derEncode(OutputStream outputStream) throws IOException {
        if (this.signedCRL == null) {
            throw new IOException("Null CRL to encode");
        }
        outputStream.write((byte[])this.signedCRL.clone());
    }

    private static final class X509IssuerSerial
    implements Comparable<X509IssuerSerial> {
        final X500Principal issuer;
        final BigInteger serial;
        volatile int hashcode = 0;

        X509IssuerSerial(X500Principal x500Principal, BigInteger bigInteger) {
            this.issuer = x500Principal;
            this.serial = bigInteger;
        }

        X509IssuerSerial(X509Certificate x509Certificate) {
            this(x509Certificate.getIssuerX500Principal(), x509Certificate.getSerialNumber());
        }

        X500Principal getIssuer() {
            return this.issuer;
        }

        BigInteger getSerial() {
            return this.serial;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof X509IssuerSerial)) {
                return false;
            }
            X509IssuerSerial x509IssuerSerial = (X509IssuerSerial)object;
            return this.serial.equals(x509IssuerSerial.getSerial()) && this.issuer.equals(x509IssuerSerial.getIssuer());
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                int n = 17;
                n = 37 * n + this.issuer.hashCode();
                this.hashcode = n = 37 * n + this.serial.hashCode();
            }
            return this.hashcode;
        }

        @Override
        public int compareTo(X509IssuerSerial x509IssuerSerial) {
            int n = this.issuer.toString().compareTo(x509IssuerSerial.issuer.toString());
            if (n != 0) {
                return n;
            }
            return this.serial.compareTo(x509IssuerSerial.serial);
        }
    }
}

