/*
 * Decompiled with CFR 0.152.
 */
package storeroom.util;

import java.io.IOException;
import java.io.InputStream;

public class ByteUtil {
    public static short twoBytesToShort(byte high, byte low) {
        return (short)((high & 0xFF) << 8 | low & 0xFF);
    }

    public static String toMacAddress(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int len = arr.length;
        while (i < len) {
            if (i < len - 1) {
                sb.append(String.valueOf(String.format("%02X", arr[i])) + ":");
            } else {
                sb.append(String.format("%02X", arr[i]));
            }
            ++i;
        }
        return sb.toString();
    }

    @Deprecated
    public static String toMacAddress_LEndian(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        int i = arr.length - 1;
        while (i >= 0) {
            if (i > 0) {
                sb.append(String.valueOf(String.format("%02X", arr[i])) + ":");
            } else {
                sb.append(String.format("%02X", arr[i]));
            }
            --i;
        }
        return sb.toString();
    }

    public static String getBytesHexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < buf.length) {
            sb.append(String.format("%02x ", buf[i]));
            if ((i + 1) % 16 == 0) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public static byte[] readInputStreamToBuf(InputStream inputStream) throws IOException {
        int readlen = 0;
        byte[] tmp = new byte[200];
        while (inputStream.available() > 0) {
            int numBytes = inputStream.read(tmp);
            readlen += numBytes;
        }
        byte[] buf = new byte[readlen];
        int i = 0;
        while (i < readlen) {
            buf[i] = tmp[i];
            ++i;
        }
        return buf;
    }
}

