/*
 * Decompiled with CFR 0.152.
 */
package model.offlineRec;

import frame.i18n.StringRes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.MultimeterClient;
import model.MultimeterReceivedData;
import storeroom.util.ByteUtil;
import storeroom.util.DateUtil;
import storeroom.util.EndianUtil;
import storeroom.util.FuncUnit;
import storeroom.util.RateUnit;

public class OfflineDataModelVariant {
    private static final int FLASH_ONE_DATA_LENGTH = 2;
    private static final int ERROR_NONE = 0;
    private List<MultimeterReceivedData> sFlashDataList;
    private ArrayList<Byte> mValidDataBuf;
    private BleAgent ag;
    private File sSavedFile;
    private String sSavedFileName = "";
    private byte[] mDataLeft_flash;
    private int mDataLeftLength_flash = 0;
    private int mMarkCount = 0;
    private boolean lastGetting = false;
    private boolean onGetting = false;
    private boolean onMark = false;
    private short mGear = (short)-4096;
    private String modeString = "FLM";
    private String funcString = "FLF";
    private String unitString = "FLU";
    private Date mStartOfflineRecTime;
    private int mOfflineRecInterval = 0;
    int readbytescount = 0;
    @Deprecated
    private byte[] LenArr = new byte[4];
    @Deprecated
    private int LenPt = 0;
    private String TAG = "OfflineDataModelVariant";
    private static final boolean DEBUG = true;
    private static final boolean INFO = true;

    public OfflineDataModelVariant(MultimeterClient mClient) {
        this.sFlashDataList = new ArrayList<MultimeterReceivedData>();
        this.mValidDataBuf = new ArrayList();
        this.ag = Platform.getBle();
    }

    public void handleData(MultimeterClient client, byte[] data, int datalength, boolean is55) {
        if (client == null || data == null || datalength <= 0) {
            this.MSG_ERROR("handleReceivedData, Invalid argument");
            return;
        }
        int leftlength = this.mDataLeftLength_flash + datalength;
        ByteBuffer buffer = ByteBuffer.allocate(leftlength);
        if (this.mDataLeftLength_flash > 0 && this.mDataLeft_flash != null) {
            buffer.put(this.mDataLeft_flash);
        }
        buffer.put(data, 0, datalength);
        byte[] tmp = buffer.array();
        int i = 0;
        int result = 0;
        while (leftlength >= 2) {
            byte low = tmp[i++];
            byte high = tmp[i++];
            leftlength -= 2;
            this.lastGetting = this.onGetting;
            boolean bl = this.onMark = (low & 0xFF) == 255 && (high & 0xFF) == 255;
            if (this.onMark && !this.onGetting) {
                ++this.mMarkCount;
                this.onGetting = this.mMarkCount == 10;
                this.MSG_DEBUG("enter.nowMark:" + this.onMark + ",c:" + this.mMarkCount);
            } else if (this.onMark && this.onGetting) {
                --this.mMarkCount;
                this.onGetting = this.mMarkCount > 0;
                this.MSG_DEBUG("leave.nowMark:" + this.onMark + ",c:" + this.mMarkCount);
            }
            if (this.onGetting && !this.onMark) {
                this.acceptValidFlashDatas(low, high);
            }
            if (!this.lastGetting || this.onGetting) continue;
            this.doEndJob(is55);
        }
        if (result != 0) {
            this.MSG_ERROR("handleReceivedData, Parse received data fail, result = " + result);
            return;
        }
        if (leftlength > 0) {
            ByteBuffer temp = ByteBuffer.allocate(leftlength);
            temp.put(tmp, i, leftlength);
            this.mDataLeft_flash = temp.array();
            this.mDataLeftLength_flash = leftlength;
        } else {
            this.mDataLeft_flash = null;
            this.mDataLeftLength_flash = 0;
        }
    }

    void acceptValidFlashDatas(byte low, byte high) {
        this.mValidDataBuf.add(low);
        this.mValidDataBuf.add(high);
        Platform.getBle().broadcast.sendBroadcast_OfflineTransmitProgress(null, 2);
    }

    void doEndJob(boolean is55) {
        this.LenPt = 0;
        BleClient mClient = this.ag.getClient();
        mClient.setTransmitState(1);
        this.parseFlashDatas(is55);
        File f = this.saveFlashDatasAfterParsed(mClient);
        this.MSG_INFO("@Flash data transmit over ,send broadcast to saveData");
        this.ag.broadcast.sendBroadcast_OfflineTransmitEnd(false, f.getAbsolutePath());
        this.readbytescount = 0;
        this.mMarkCount = 0;
    }

    void parseFlashDatas(boolean is55) {
        if (this.mValidDataBuf == null || this.mValidDataBuf.size() == 0) {
            return;
        }
        this.MSG_INFO("@ParseFlashDatas");
        int p = 0;
        int size = this.mValidDataBuf.size();
        byte[] arr = new byte[size];
        while (p < size) {
            arr[p] = this.mValidDataBuf.get(p);
            ++p;
        }
        p = 0;
        BleClient mClient = this.ag.getClient();
        boolean onDate = mClient.getBleSeries().isSurportOfflineDate();
        if (onDate) {
            this.mStartOfflineRecTime = this.parseDate(arr, p);
            this.mOfflineRecInterval = this.parseInterval(arr, p += 8);
            p += 4;
        }
        int len = EndianUtil.nextIntL(arr, p);
        p += 4;
        this.MSG_DEBUG("###OfflineReceivedDataLen:" + len);
        int idx = 0;
        while (p + 1 < size) {
            byte low = arr[p++];
            byte high = arr[p++];
            this.parseOneUnit(low, high, idx++, is55);
        }
        this.mValidDataBuf.clear();
        this.MSG_DEBUG("###After parse mValidDataBuf size is:" + this.mValidDataBuf.size());
    }

    private void parseOneUnit(byte low, byte high, int idx, boolean is55) {
        boolean isGears;
        double DATA = 0.0;
        boolean bl = isGears = !is55 && (high & 0xFC) == 240 || is55 && (high & 0xF8) == 240;
        if (isGears) {
            String rate;
            this.mGear = ByteUtil.twoBytesToShort(high, low);
            switch ((this.mGear & 0x38) >> 3) {
                case 0: {
                    rate = RateUnit.p.toString();
                    break;
                }
                case 1: {
                    rate = RateUnit.n.toString();
                    break;
                }
                case 2: {
                    rate = RateUnit.u.toString();
                    break;
                }
                case 3: {
                    rate = RateUnit.m.toString();
                    break;
                }
                case 4: {
                    rate = RateUnit.None.toString();
                    break;
                }
                case 5: {
                    rate = RateUnit.K.toString();
                    break;
                }
                case 6: {
                    rate = RateUnit.M.toString();
                    break;
                }
                case 7: {
                    rate = RateUnit.G.toString();
                    break;
                }
                default: {
                    rate = "?";
                }
            }
            switch ((this.mGear & 0x3C0) >> 6) {
                case 0: {
                    this.funcString = FuncUnit.DC.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.volt");
                    break;
                }
                case 1: {
                    this.funcString = FuncUnit.AC.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.volt");
                    break;
                }
                case 2: {
                    this.funcString = FuncUnit.DC.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.ampere");
                    break;
                }
                case 3: {
                    this.funcString = FuncUnit.AC.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.ampere");
                    break;
                }
                case 4: {
                    this.funcString = FuncUnit.OHM.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.ohm");
                    break;
                }
                case 5: {
                    this.funcString = FuncUnit.F.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.farad");
                    break;
                }
                case 6: {
                    this.funcString = FuncUnit.Hz.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.Hz");
                    break;
                }
                case 7: {
                    this.funcString = FuncUnit.Percent.toString();
                    this.unitString = StringRes.getString("unit.percent");
                    break;
                }
                case 8: {
                    this.funcString = FuncUnit.Centigrade.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.centigrade");
                    break;
                }
                case 9: {
                    this.funcString = FuncUnit.Fahrenheit.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.fahrenheit");
                    break;
                }
                case 10: {
                    this.funcString = FuncUnit.Diode.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.volt");
                    break;
                }
                case 11: {
                    this.funcString = FuncUnit.Continuity.toString();
                    this.unitString = String.valueOf(rate) + StringRes.getString("unit.ohm");
                    break;
                }
                case 12: {
                    this.funcString = this.unitString = FuncUnit.HFEC.toString();
                    break;
                }
                case 13: {
                    this.funcString = this.unitString = FuncUnit.ADP.toString();
                    break;
                }
                default: {
                    this.unitString = "?";
                    this.funcString = "?";
                    break;
                }
            }
        } else {
            boolean isU_O;
            boolean negative;
            String point = "?";
            short oneData = ByteUtil.twoBytesToShort(high, low);
            if (!is55) {
                negative = high >> 7 != 0;
                DATA = oneData & Short.MAX_VALUE;
            } else {
                negative = (this.mGear >> 10 & 1) != 0;
                DATA = oneData;
            }
            switch (this.mGear & 7) {
                case 0: {
                    point = "00000";
                    break;
                }
                case 1: {
                    DATA /= 10.0;
                    point = "0000.0";
                    break;
                }
                case 2: {
                    DATA /= 100.0;
                    point = "000.00";
                    break;
                }
                case 3: {
                    DATA /= 1000.0;
                    point = "00.000";
                    break;
                }
                case 4: {
                    DATA /= 10000.0;
                    point = "0.0000";
                    break;
                }
                case 6: {
                    point = "UL";
                    break;
                }
                case 7: {
                    point = "OL";
                    break;
                }
                default: {
                    point = "?";
                }
            }
            boolean bl2 = isU_O = point.equals("UL") || point.equals("OL");
            if (negative) {
                DATA = -DATA;
            }
            String DataString = isU_O ? point : String.valueOf(DATA);
            MultimeterReceivedData receivedData = new MultimeterReceivedData();
            receivedData.SourceDataLength = 2;
            receivedData.Index = this.sFlashDataList.size();
            receivedData.Mode = this.modeString;
            receivedData.Func = this.funcString;
            receivedData.Unit = this.unitString;
            receivedData.ValueString = DataString;
            receivedData.Value = DATA;
            Date nextdate = DateUtil.nextDate(this.mStartOfflineRecTime, this.mOfflineRecInterval * idx);
            receivedData.initTime_Date(nextdate);
            this.sFlashDataList.add(receivedData);
        }
    }

    public File saveFlashDatasAfterParsed(MultimeterClient client) {
        if (this.sFlashDataList == null || this.sFlashDataList.size() <= 0) {
            return null;
        }
        this.MSG_INFO("@SaveFlashDatasAfterParsed");
        String clientString = this.sSavedFileName;
        if (this.sSavedFileName == null || this.sSavedFileName.equals("")) {
            clientString = "";
        }
        clientString = String.valueOf(clientString) + "_" + DateUtil.sf2.format(Calendar.getInstance().getTime());
        File file = null;
        try {
            String path = System.getProperty("user.dir");
            File sdCard = new File(path);
            sdCard = new File(sdCard, "/DATAS/OfflineFiles");
            if (!sdCard.exists()) {
                sdCard.mkdirs();
            }
            file = new File(sdCard, "[Offline]_" + clientString + ".xls");
            this.MSG_DEBUG("file.isExists?:" + file.exists() + ",can write?" + file.canWrite() + "\n" + file.getAbsolutePath());
            FileOutputStream output = new FileOutputStream(file);
            OutputStreamWriter doutput = new OutputStreamWriter((OutputStream)output, "UTF-16");
            int i = 0;
            while (i < this.sFlashDataList.size()) {
                MultimeterReceivedData data = this.sFlashDataList.get(i);
                String dataString = new String(String.valueOf(i) + ",\t" + data.Func + ",\t" + data.ValueString + ",\t" + data.Unit + "\r\n");
                doutput.write(dataString);
                ++i;
            }
            doutput.close();
            output.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.MSG_ERROR("Create [Offline] file fail: " + clientString + ".xls ");
            return null;
        }
        catch (IOException iOException) {
            this.MSG_ERROR("Write [Offline] file fail: " + clientString + ".xls ");
            return null;
        }
        this.clearDataList();
        this.sSavedFile = file;
        return file;
    }

    public void clearDataList() {
        this.sFlashDataList.clear();
    }

    public List<MultimeterReceivedData> getFlashDataList() {
        return this.sFlashDataList;
    }

    public void preSetFileName(String filename) {
        this.sSavedFileName = filename;
    }

    public File getFlashDataFile() {
        return this.sSavedFile;
    }

    private Date parseDate(byte[] arr, int p) {
        String y1 = arr[p] < 10 ? "0" + arr[p] : String.valueOf(arr[p]);
        String y2 = arr[++p] < 10 ? "0" + arr[p] : String.valueOf(arr[p]);
        String MM = arr[++p] < 10 ? "0" + arr[p] : String.valueOf(arr[p]);
        String dd = arr[++p] < 10 ? "0" + arr[p] : String.valueOf(arr[p]);
        String kk = arr[++p] < 10 ? "0" + arr[p] : String.valueOf(arr[p]);
        String mm = arr[++p] < 10 ? "0" + arr[p] : String.valueOf(arr[p]);
        String ss = arr[++p] < 10 ? "0" + arr[p] : String.valueOf(arr[p]);
        ++p;
        String dateStr = String.valueOf(y1) + y2 + MM + dd + kk + mm + ss;
        Date day = null;
        try {
            day = DateUtil.StrToDate(dateStr);
        }
        catch (ParseException parseException) {
            return null;
        }
        return day;
    }

    private int parseInterval(byte[] arr, int p) {
        int i = EndianUtil.nextIntL(arr, p);
        return i;
    }

    @Deprecated
    private void acceptNParseFlashDatas(byte low, byte high, boolean is55) {
        if (this.LenPt < this.LenArr.length) {
            this.LenArr[this.LenPt++] = low;
            this.LenArr[this.LenPt++] = high;
        } else {
            if (this.LenPt == this.LenArr.length) {
                int len = this.LenArr[3] << 24 | this.LenArr[2] << 16 | this.LenArr[1] << 8 | this.LenArr[0];
                ++this.LenPt;
                this.MSG_DEBUG("$$$$$$$$$$$$$$##### LenPt:" + len);
            }
            this.parseOneUnit(low, high, 0, is55);
        }
    }

    private void MSG_DEBUG(String msg) {
        System.out.println("dbg:" + msg);
    }

    private void MSG_ERROR(String msg) {
        System.err.println(msg);
    }

    private void MSG_INFO(String msg) {
        System.out.println("info:" + msg);
    }
}

