/*
 * Decompiled with CFR 0.152.
 */
package model.offlineRec;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import model.MultimeterClient;
import model.MultimeterReceivedData;
import storeroom.util.ByteUtil;
import storeroom.util.FuncUnit;
import storeroom.util.RateUnit;

public class OfflineDataModelUnuse {
    private List<MultimeterReceivedData> mFlashDataList;
    private File savedFile;
    private String savedFileName = "";
    private byte[] mDataLeft_flash;
    private int mDataLeftLength_flash = 0;
    private static final int FLASH_ONE_DATA_LENGTH = 2;
    private static final int ERROR_NONE = 0;
    private byte[] LenArr = new byte[4];
    private int LenPt = 0;
    private int markCount = 0;
    private boolean status = false;
    private boolean onGetting = false;
    private boolean onMark = false;
    private short gear = (short)-4096;
    private String ModeString = "FLM";
    private String FuncString = "FLF";
    private String unitString = "FLU";
    private int readbytescount = 0;
    protected String TAG = "OfflineDataModel";
    protected static final boolean Debug = false;
    protected static final boolean Info = true;

    public OfflineDataModelUnuse() {
        this.mFlashDataList = new ArrayList<MultimeterReceivedData>();
    }

    public List<MultimeterReceivedData> getFlashDataList() {
        return this.mFlashDataList;
    }

    public void handleData(MultimeterClient client, byte[] data, int datalength) {
        if (client == null || data == null || datalength <= 0) {
            this.MSG_ERROR("handleReceivedData, Invalid argument");
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.mDataLeftLength_flash + datalength);
        if (this.mDataLeftLength_flash > 0 && this.mDataLeft_flash != null) {
            buffer.put(this.mDataLeft_flash);
        }
        buffer.put(data, 0, datalength);
        byte[] tmp = buffer.array();
        int leftlength = this.mDataLeftLength_flash + datalength;
        int result = 0;
        int i = 0;
        while (leftlength >= 2) {
            byte low = tmp[i++];
            byte high = tmp[i++];
            leftlength -= 2;
            this.status = this.onGetting;
            boolean bl = this.onMark = (low & 0xFF) == 255 && (high & 0xFF) == 255;
            if (this.onMark && !this.onGetting) {
                this.MSG_INFO("nowMark:" + this.onMark + "\u951b\u5b91:" + this.markCount);
                ++this.markCount;
                this.readbytescount = 0;
            } else if (this.onMark && this.onGetting) {
                this.MSG_INFO("nowMark:" + this.onMark + "\u951b\u5b91:" + this.markCount);
                --this.markCount;
            }
            if (this.markCount >= 10) {
                this.onGetting = true;
            } else if (this.markCount <= 0) {
                this.onGetting = false;
            }
            if (this.status && !this.onGetting) {
                client.setTransmitState(1);
                this.LenPt = 0;
                this.MSG_INFO("Flash data transmit over ,send broadcast to saveData");
                this.saveFlashDatasAfterParsed(client);
            }
            if (!this.onGetting || this.onMark) continue;
            this.parseStruct(client, tmp, low, high, i);
        }
        if (result != 0) {
            this.MSG_ERROR("handleReceivedData, Parse received data fail, result = " + result);
            return;
        }
        if (leftlength > 0) {
            this.MSG_DEBUG("handleReceivedData, " + leftlength + " bytes left");
            ByteBuffer temp = ByteBuffer.allocate(leftlength);
            temp.put(tmp, i, leftlength);
            this.mDataLeft_flash = temp.array();
            this.mDataLeftLength_flash = leftlength;
        } else {
            this.mDataLeft_flash = null;
            this.mDataLeftLength_flash = 0;
        }
    }

    void parseStruct(MultimeterClient client, byte[] tmp, byte low, byte high, int i) {
        double DATA = 0.0;
        if (this.LenPt < this.LenArr.length) {
            this.LenArr[this.LenPt++] = low;
            this.LenArr[this.LenPt++] = high;
        } else {
            if (this.LenPt == this.LenArr.length) {
                int len = this.LenArr[3] << 24 | this.LenArr[2] << 16 | this.LenArr[1] << 8 | this.LenArr[0];
                ++this.LenPt;
                this.MSG_INFO("$$$$$$$$$$$$$$##### LenPt:" + len);
            }
            if ((high & 0xFC) == 240) {
                String rate;
                this.MSG_INFO("$$$$$$$$$$$$$$##### In Gear:");
                this.gear = ByteUtil.twoBytesToShort(high, low);
                switch ((this.gear & 0x38) >> 3) {
                    case 0: {
                        rate = RateUnit.p.toString();
                        break;
                    }
                    case 1: {
                        rate = RateUnit.n.toString();
                        break;
                    }
                    case 2: {
                        rate = RateUnit.u.toString();
                        break;
                    }
                    case 3: {
                        rate = RateUnit.m.toString();
                        break;
                    }
                    case 4: {
                        rate = RateUnit.None.toString();
                        break;
                    }
                    case 5: {
                        rate = RateUnit.K.toString();
                        break;
                    }
                    case 6: {
                        rate = RateUnit.M.toString();
                        break;
                    }
                    case 7: {
                        rate = RateUnit.G.toString();
                        break;
                    }
                    default: {
                        rate = "?";
                    }
                }
                switch ((this.gear & 0x3C0) >> 6) {
                    case 0: {
                        this.FuncString = FuncUnit.DC.toString();
                        break;
                    }
                    case 1: {
                        this.FuncString = FuncUnit.AC.toString();
                        break;
                    }
                    case 2: {
                        this.FuncString = FuncUnit.DC.toString();
                        break;
                    }
                    case 3: {
                        this.FuncString = FuncUnit.AC.toString();
                        break;
                    }
                    case 4: {
                        this.unitString = String.valueOf(rate) + this.FuncString;
                        break;
                    }
                    case 5: {
                        this.FuncString = FuncUnit.F.toString();
                        this.unitString = String.valueOf(rate) + this.FuncString;
                        break;
                    }
                    case 6: {
                        this.FuncString = FuncUnit.Hz.toString();
                        this.unitString = String.valueOf(rate) + this.FuncString;
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        this.FuncString = FuncUnit.Diode.toString();
                        this.unitString = String.valueOf(rate) + this.FuncString;
                        break;
                    }
                    case 11: {
                        this.FuncString = this.unitString = FuncUnit.Continuity.toString();
                        break;
                    }
                    case 12: {
                        this.FuncString = this.unitString = FuncUnit.HFEC.toString();
                        break;
                    }
                    case 13: {
                        this.FuncString = this.unitString = FuncUnit.ADP.toString();
                        break;
                    }
                    default: {
                        this.unitString = "?";
                        this.FuncString = "?";
                        break;
                    }
                }
            } else {
                boolean isU_O;
                String point = "?";
                short oneData = ByteUtil.twoBytesToShort(high, low);
                boolean negative = high >> 7 != 0;
                DATA = oneData & Short.MAX_VALUE;
                switch (this.gear & 7) {
                    case 0: {
                        point = "00000";
                        break;
                    }
                    case 1: {
                        DATA /= 10.0;
                        point = "0000.0";
                        break;
                    }
                    case 2: {
                        DATA /= 100.0;
                        point = "000.00";
                        break;
                    }
                    case 3: {
                        DATA /= 1000.0;
                        point = "00.000";
                        break;
                    }
                    case 4: {
                        DATA /= 10000.0;
                        point = "0.0000";
                        break;
                    }
                    case 6: {
                        point = "UL";
                        break;
                    }
                    case 7: {
                        point = "OL";
                        break;
                    }
                    default: {
                        point = "?";
                    }
                }
                boolean bl = isU_O = point.equals("UL") || point.equals("OL");
                if (negative) {
                    DATA = -DATA;
                }
                String DataString = isU_O ? point : String.valueOf(DATA);
                MultimeterReceivedData receivedData = new MultimeterReceivedData();
                ByteBuffer source = ByteBuffer.allocate(2);
                source.put(tmp, i - 2, 2);
                receivedData.SourceData = source.array();
                receivedData.SourceDataLength = 2;
                receivedData.Index = this.mFlashDataList.size();
                receivedData.Mode = this.ModeString;
                receivedData.Func = this.FuncString;
                receivedData.Unit = this.unitString;
                receivedData.ValueString = DataString;
                receivedData.Value = DATA;
                this.MSG_INFO("In number,id:" + receivedData.Index + ",Mode:" + this.ModeString + ",Func:" + this.FuncString + ",Unit:" + this.unitString + ",Vs:" + DataString + ",v:" + DATA);
                this.mFlashDataList.add(receivedData);
            }
        }
    }

    public File saveFlashDatasAfterParsed(MultimeterClient client) {
        if (this.mFlashDataList == null || this.mFlashDataList.size() <= 0) {
            return null;
        }
        String clientString = this.savedFileName;
        if (this.savedFileName != null) {
            this.savedFileName.equals("");
        }
        this.MSG_DEBUG("saveOfflineData, DataSize: " + this.mFlashDataList.size());
        File file = null;
        try {
            File sdCard = null;
            this.MSG_ERROR("sdCard.isExists?:" + sdCard.exists() + ",canWrite:" + sdCard.canWrite());
            if (!sdCard.exists()) {
                sdCard.mkdirs();
            }
            file = new File(sdCard, "[Offline]_" + clientString + ".csv");
            this.MSG_INFO("file.isExists?:" + file.exists() + ",can write?" + file.canWrite());
            FileOutputStream output = new FileOutputStream(file);
            OutputStreamWriter doutput = new OutputStreamWriter((OutputStream)output, "utf-16");
            int i = 0;
            while (i < this.mFlashDataList.size()) {
                MultimeterReceivedData data = this.mFlashDataList.get(i);
                String dataString = new String(String.valueOf(i) + ",\t" + data.Func + ",\t" + data.ValueString + ",\t" + data.Unit + "\r\n");
                doutput.write(dataString);
                ++i;
            }
            doutput.close();
            output.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.MSG_ERROR("Create [Offline] file fail: " + clientString + ".csv ");
            return null;
        }
        catch (IOException iOException) {
            this.MSG_ERROR("Write [Offline] file fail: " + clientString + ".csv ");
            return null;
        }
        this.clearDataList();
        this.savedFile = file;
        return file;
    }

    @Deprecated
    public void clearDataList() {
        this.mFlashDataList.clear();
    }

    public void preSetFileName(String filename) {
        this.savedFileName = filename;
    }

    public File getFlashDataFile() {
        return this.savedFile;
    }

    protected void MSG_DEBUG(String msg) {
    }

    protected void MSG_ERROR(String msg) {
    }

    protected void MSG_INFO(String msg) {
    }
}

