/*
 * Decompiled with CFR 0.152.
 */
package model;

import frame.i18n.StringRes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.MultimeterReceivedData;
import model.offlineRec.OfflineDataModelVariant;
import storeroom.util.DateUtil;
import storeroom.util.FuncUnit;
import storeroom.util.RateUnit;

public class MultimeterClient {
    protected String TAG = "MultimeterClient";
    protected static final boolean Debug = false;
    protected static final boolean Info = true;
    public static final int STATE_DISCONNECTED = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_CONNECTED = 3;
    public static final int STATE_TRANSMIT_REAL_TIME = 1;
    public static final int STATE_TRANSMIT_FLASH = 2;
    public static final int REASON_CONNECT_SUCCESS = 1;
    public static final int REASON_CONNECT_FAIL = 2;
    public static final int REASON_CONNECTION_LOST = 3;
    public static final int REASON_DEVICE_UNAUTHORIZE = 4;
    public static final int REASON_SWITCH_PAGE = 5;
    public static final int REASON_SERIES_UNAUTHORIZE = 6;
    public static final int ID_VERIFY = 0;
    public static final int READ_DEVICEINFO = 1;
    public static final int WRITE_STARTRECORD = 2;
    public static final int WRITE_READFLASH = 3;
    public static final int WRITE_READLEN = 4;
    public static final int WRITE_STOP_RECORD = 5;
    public static final int WRITE_RENAME_CMD = 6;
    protected int mState = 1;
    protected int mTransmitState = 1;
    protected String mAddress;
    public boolean needSingleton = false;
    private static int IntervalTime = 0;
    protected List<MultimeterReceivedData> mDataList;
    private OfflineDataModelVariant offlineDataModel;
    protected BleAgent ag;
    private static final int ONE_DATA_LENGTH = 14;
    private static final int COMMON_ONE_DATA_LENGTH = 6;
    private byte[] mDataLeft;
    private int mDataLeftLength = 0;
    private static final int ERROR_NONE = 0;
    private static final int ERROR_INCORRECT_SIGN_BYTE = 1;
    private static final int ERROR_INCORRECT_SPACE_BYTE = 2;
    private static final int ERROR_INCORRECT_EOF_BYTE = 3;
    private static final int ERROR_INCORRECT_ENTER_BYTE = 4;
    private boolean onCommonPrint = false;

    public static void setIntervalTime(int intervalTime) {
        IntervalTime = intervalTime;
    }

    protected void MSG_DEBUG(String msg) {
        System.out.println(String.valueOf(this.TAG) + "#dbg:  " + msg);
    }

    protected void MSG_ERROR(String msg) {
        System.err.println(String.valueOf(this.TAG) + "#  " + msg);
    }

    protected void MSG_INFO(String msg) {
        System.out.println(String.valueOf(this.TAG) + "#info:" + msg);
    }

    public MultimeterClient(String address) {
        this.mAddress = address;
        this.mState = 1;
        this.mDataList = new ArrayList<MultimeterReceivedData>();
        this.offlineDataModel = new OfflineDataModelVariant(this);
    }

    public boolean equals(MultimeterClient client) {
        return this.mAddress.equals(client.getAddress());
    }

    public void setState(int state) {
        this.MSG_DEBUG("setState, newState = " + state);
        this.mState = state;
    }

    public int getState() {
        return this.mState;
    }

    public void setTransmitState(int state) {
        this.mTransmitState = state;
        switch (state) {
            case 2: {
                System.out.println("########setTransmitState:FLASH");
                break;
            }
            case 1: {
                System.out.println("########setTransmitState:REAL_TIME");
                break;
            }
        }
    }

    public boolean isOnFlashTransmit() {
        return this.mTransmitState == 2;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getDevName() {
        String DevName = this.mAddress.replace(":", "_");
        return DevName;
    }

    public List<MultimeterReceivedData> getReceivedData() {
        return this.mDataList;
    }

    public void clearReceivedData() {
        this.MSG_DEBUG("clearReceivedData");
        this.mDataList.clear();
    }

    public void saveReceivedData() {
        if (this.mDataList == null || this.mDataList.size() <= 0) {
            return;
        }
        this.MSG_DEBUG("saveReceivedData, DataSize: " + this.mDataList.size());
        String date = DateUtil.sf2.format(Calendar.getInstance().getTime());
        String clientString = this.getDevName();
        this.MSG_DEBUG("saveReceivedData @ " + clientString + "_" + date.toString() + ".csv");
        try {
            String path = System.getProperty("user.dir");
            File sdCard = new File(String.valueOf(path) + "/DATAS/");
            if (!sdCard.exists()) {
                sdCard.mkdirs();
            }
            File file = new File(sdCard, "(" + clientString + ")_" + date.toString() + ".csv");
            FileOutputStream output = new FileOutputStream(file);
            OutputStreamWriter doutput = new OutputStreamWriter((OutputStream)output, "GBK");
            int i = 0;
            while (i < this.mDataList.size()) {
                MultimeterReceivedData data = this.mDataList.get(i);
                String dataString = new String(String.valueOf(i) + ",\t" + data.Func + ",\t" + data.ValueString + ",\t" + data.Unit + ",\t" + data.Time + ",\t\t" + data.Date + "\r\n");
                doutput.write(dataString);
                ++i;
            }
            doutput.close();
            output.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.MSG_ERROR("Create file: " + clientString + "_" + date.toString() + ".csv fail");
            return;
        }
        catch (IOException iOException) {
            this.MSG_ERROR("Write file: " + clientString + "_" + date.toString() + ".csv fail");
            return;
        }
        this.mDataList.clear();
    }

    public int hashCode() {
        return this.mAddress.hashCode();
    }

    private double unifiedUnit(double oValue, String unit) {
        double v = oValue;
        if (unit.equalsIgnoreCase("mV") || unit.equalsIgnoreCase("\u6e2dA") || unit.equalsIgnoreCase("\u60df") || unit.equalsIgnoreCase("nF") || unit.equalsIgnoreCase("Hz")) {
            BigDecimal df = new BigDecimal(oValue);
            v = df.setScale(5, 5).doubleValue();
        } else if (unit.equalsIgnoreCase("A") || unit.equalsIgnoreCase("M\u60df") || unit.equalsIgnoreCase("MHz")) {
            v = oValue * 1000.0;
        }
        return v;
    }

    public void handleReceivedData_common(MultimeterClient client, byte[] data, int datalength, boolean is55) {
        if (client == null || data == null || datalength <= 0) {
            this.MSG_ERROR("handleReceivedData, Invalid argument");
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.mDataLeftLength + datalength);
        if (this.mDataLeftLength > 0 && this.mDataLeft != null) {
            buffer.put(this.mDataLeft);
        }
        buffer.put(data, 0, datalength);
        byte[] tmp = buffer.array();
        int leftlength = this.mDataLeftLength + datalength;
        int result = 0;
        int i = 0;
        while (leftlength >= 6) {
            String DataString;
            String point;
            int ORG_DATA;
            int oneData;
            String unitString;
            String FuncString;
            String rate;
            StringBuilder ModeBuilder = new StringBuilder();
            String UnitType = "";
            boolean negative = false;
            byte low = tmp[i++];
            byte high = tmp[i++];
            short gear = this.twoBytesToShort(high, low);
            switch ((gear & 0x38) >> 3) {
                case 0: {
                    rate = RateUnit.p.toString();
                    break;
                }
                case 1: {
                    rate = RateUnit.n.toString();
                    break;
                }
                case 2: {
                    rate = RateUnit.u.toString();
                    break;
                }
                case 3: {
                    rate = RateUnit.m.toString();
                    break;
                }
                case 4: {
                    rate = RateUnit.None.toString();
                    break;
                }
                case 5: {
                    rate = RateUnit.K.toString();
                    break;
                }
                case 6: {
                    rate = RateUnit.M.toString();
                    break;
                }
                case 7: {
                    rate = RateUnit.G.toString();
                    break;
                }
                default: {
                    rate = "?";
                }
            }
            switch ((gear & 0x3C0) >> 6) {
                case 0: {
                    FuncString = FuncUnit.DC.toString();
                    UnitType = StringRes.getString("unit.volt");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 1: {
                    FuncString = FuncUnit.AC.toString();
                    UnitType = StringRes.getString("unit.volt");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 2: {
                    FuncString = FuncUnit.DC.toString();
                    UnitType = StringRes.getString("unit.ampere");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 3: {
                    FuncString = FuncUnit.AC.toString();
                    UnitType = StringRes.getString("unit.ampere");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 4: {
                    FuncString = FuncUnit.OHM.toString();
                    UnitType = StringRes.getString("unit.ohm");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 5: {
                    FuncString = FuncUnit.F.toString();
                    UnitType = StringRes.getString("unit.farad");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 6: {
                    FuncString = FuncUnit.Hz.toString();
                    UnitType = StringRes.getString("unit.Hz");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 7: {
                    FuncString = FuncUnit.Percent.toString();
                    UnitType = unitString = StringRes.getString("unit.percent");
                    break;
                }
                case 8: {
                    FuncString = FuncUnit.Centigrade.toString();
                    UnitType = StringRes.getString("unit.centigrade");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 9: {
                    FuncString = FuncUnit.Fahrenheit.toString();
                    UnitType = StringRes.getString("unit.fahrenheit");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 10: {
                    FuncString = FuncUnit.Diode.toString();
                    UnitType = StringRes.getString("unit.volt");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 11: {
                    FuncString = FuncUnit.Continuity.toString();
                    UnitType = StringRes.getString("unit.ohm");
                    unitString = String.valueOf(rate) + UnitType;
                    break;
                }
                case 12: {
                    FuncString = unitString = FuncUnit.HFEC.toString();
                    UnitType = unitString;
                    break;
                }
                case 13: {
                    BleClient bc = (BleClient)client;
                    if (bc.getBleSeries().isOWSeries()) {
                        FuncString = unitString = FuncUnit.NCV.toString();
                        System.out.println("isOW18 NCV");
                        break;
                    }
                    FuncString = unitString = FuncUnit.ADP.toString();
                    System.out.println("else ADP");
                    break;
                }
                default: {
                    unitString = "Null";
                    FuncString = "Null";
                    UnitType = "Null";
                }
            }
            low = tmp[i++];
            high = tmp[i++];
            short func = this.twoBytesToShort(high, low);
            char[] binary = Integer.toBinaryString(func).toCharArray();
            Status[] allStatus = Status.values();
            int m = 0;
            int n = 0;
            int al = allStatus.length;
            int bl = binary.length;
            while (m < al) {
                if (m >= al - bl) {
                    if (binary[n] == '1') {
                        ModeBuilder.append(allStatus[m].name());
                        ModeBuilder.append(",");
                        if (this.onCommonPrint) {
                            System.out.println("Status: " + allStatus[m].name() + "," + binary[n] + "(" + m + "),");
                        }
                    }
                    ++n;
                }
                ++m;
            }
            String ModeString = ModeBuilder.toString();
            low = tmp[i++];
            high = tmp[i++];
            if (is55) {
                oneData = this.twoBytesToInt(high, low);
                negative = (gear >> 10 & 1) != 0;
                ORG_DATA = oneData;
            } else {
                oneData = this.twoBytesToShort(high, low);
                negative = high >> 7 != 0;
                ORG_DATA = oneData & Short.MAX_VALUE;
            }
            double DATA = ORG_DATA;
            int decimal = gear & 7;
            switch (decimal) {
                case 0: {
                    point = "00000";
                    break;
                }
                case 1: {
                    DATA /= 10.0;
                    point = "0000.0";
                    break;
                }
                case 2: {
                    DATA /= 100.0;
                    point = "000.00";
                    break;
                }
                case 3: {
                    DATA /= 1000.0;
                    point = "00.000";
                    break;
                }
                case 4: {
                    DATA /= 10000.0;
                    point = "0.0000";
                    break;
                }
                case 6: {
                    point = "UL";
                    break;
                }
                case 7: {
                    point = "OL";
                    break;
                }
                default: {
                    point = "err point";
                }
            }
            boolean isU_O = point.equals("UL") || point.equals("OL");
            String string = DataString = isU_O ? point : String.valueOf(DATA);
            if (FuncString.equalsIgnoreCase(FuncUnit.NCV.toString())) {
                switch ((int)DATA) {
                    case 0: {
                        DataString = "EF";
                        break;
                    }
                    case 1: {
                        DataString = "-";
                        break;
                    }
                    case 2: {
                        DataString = "- -";
                        break;
                    }
                    case 3: {
                        DataString = "- - -";
                        break;
                    }
                    case 4: {
                        DataString = "- - - -";
                    }
                }
            } else {
                int dec;
                String v_t;
                BleClient bc = (BleClient)client;
                if (bc.getBleSeries().isB41() || bc.getBleSeries().isOW55()) {
                    switch (decimal) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            v_t = String.format("%05d", ORG_DATA);
                            dec = 5 - decimal;
                            DataString = String.valueOf(v_t.substring(0, dec)) + "." + v_t.substring(dec);
                        }
                    }
                } else {
                    switch (decimal) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            v_t = String.format("%04d", ORG_DATA);
                            dec = 4 - decimal;
                            DataString = String.valueOf(v_t.substring(0, dec)) + "." + v_t.substring(dec);
                        }
                    }
                }
            }
            if (negative) {
                DATA = -DATA;
                DataString = "-" + DataString;
            }
            MultimeterReceivedData receivedData = new MultimeterReceivedData();
            ByteBuffer source = ByteBuffer.allocate(6);
            source.put(tmp, i - 6, 6);
            receivedData.mAddress = this.mAddress;
            receivedData.SourceData = source.array();
            receivedData.SourceDataLength = 6;
            receivedData.Index = this.mDataList.size();
            receivedData.Mode = ModeString;
            receivedData.Func = FuncString;
            receivedData.ValueString = DataString;
            receivedData.UnitType = UnitType;
            receivedData.Unit = unitString;
            receivedData.Value = DATA;
            receivedData.Range = decimal;
            this.mDataList.add(receivedData);
            if (this.onCommonPrint) {
                System.out.println("Mode\u951b\ufffd" + ModeString);
                System.out.println("#Func\u951b\ufffd" + FuncString);
                System.out.println("ValueString\u951b\ufffd" + DataString);
                System.out.println("UnitType\u951b\ufffd" + UnitType);
                System.out.println("Unit\u951b\ufffd" + unitString);
                System.out.println("Value\u951b\ufffd" + DATA);
                System.out.println("#Range\u951b\ufffd" + decimal);
            }
            Platform.getBle().broadcast.sendRealDataBroadcast(0, receivedData);
            leftlength -= 6;
        }
        if (result != 0) {
            this.MSG_ERROR("handleReceivedData, Parse received data fail, result = " + result);
            return;
        }
        if (leftlength > 0) {
            ByteBuffer temp = ByteBuffer.allocate(leftlength);
            temp.put(tmp, i, leftlength);
            this.mDataLeft = temp.array();
            this.mDataLeftLength = leftlength;
        } else {
            this.mDataLeft = null;
            this.mDataLeftLength = 0;
        }
    }

    private short twoBytesToShort(byte high, byte low) {
        return (short)((high & 0xFF) << 8 | low & 0xFF);
    }

    private int twoBytesToInt(byte high, byte low) {
        return (high & 0xFF) << 8 | low & 0xFF;
    }

    protected void handleReceivedData_flash55(MultimeterClient client, byte[] data, int datalength) {
        this.offlineDataModel.handleData(client, data, datalength, true);
    }

    protected void handleReceivedData_flash2(MultimeterClient client, byte[] data, int datalength) {
        this.offlineDataModel.handleData(client, data, datalength, false);
    }

    public void preSetFileName(String filename) {
        this.offlineDataModel.preSetFileName(filename);
    }

    public static enum Status {
        VBAR(13),
        LPF1(12),
        LPF0(11),
        UL(10),
        PMAX(9),
        PMIN(8),
        RMR(7),
        OL(6),
        MAX(5),
        MIN(4),
        Bat(3),
        AUTO(2),
        REL(1),
        HOLD(0);

        private boolean on = false;
        private int order = -1;

        private Status(int code) {
            this.order = code;
        }
    }
}

