/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import kernal.BleClient;
import model.BleClientGattCallback;
import model.ConnHandleResult;

public class BleSlaveManager {
    private static ArrayList<BleClient> slaves = new ArrayList();
    private static int USER_FOCUSE_SLAVE = 0;

    public static boolean onCreateClient(String addr, BleClientGattCallback bleCallback) {
        for (BleClient c : slaves) {
            if (!c.getAddress().equalsIgnoreCase(addr)) continue;
            return false;
        }
        BleClient mClient = new BleClient(addr, bleCallback);
        slaves.add(mClient);
        return true;
    }

    public static boolean onPopupClient(BleClient c) {
        if (slaves.contains(c)) {
            slaves.remove(c);
            return true;
        }
        return false;
    }

    public static void onPopupAll() {
        for (BleClient c : slaves) {
            System.err.println("BleSlaveManager.onPupupAll.slaves.size:" + slaves.size());
            c.disconnect();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        slaves.clear();
    }

    public static ArrayList<BleClient> getClients() {
        return slaves;
    }

    public static BleClient getClient(String addr) {
        for (BleClient c : slaves) {
            if (!c.getAddress().equalsIgnoreCase(addr)) continue;
            return c;
        }
        return null;
    }

    public static int setUserForcusSlave(String addr) {
        int i = 0;
        for (BleClient c : slaves) {
            if (c.getAddress().equalsIgnoreCase(addr)) {
                USER_FOCUSE_SLAVE = i;
                return USER_FOCUSE_SLAVE;
            }
            ++i;
        }
        return -1;
    }

    public static BleClient getClient(int idx) {
        if (idx >= 0 && idx < slaves.size()) {
            return slaves.get(idx);
        }
        return null;
    }

    public static BleClient getSelectedClient() {
        if (slaves != null && slaves.size() > 0) {
            int sel = USER_FOCUSE_SLAVE;
            if (sel < 0) {
                sel = 0;
            }
            if (sel >= slaves.size()) {
                sel = slaves.size() - 1;
            }
            return slaves.get(sel);
        }
        return null;
    }

    public void on_GAP_EstablishLink(int nowStatus, ConnHandleResult tmpConnResult) {
        for (BleClient mClient : slaves) {
            if (!mClient.getAddress().equalsIgnoreCase(tmpConnResult.Address)) continue;
            mClient.onConnectionStateChange(nowStatus);
            mClient.setConnHandle(tmpConnResult);
            mClient.readDeviceInfo();
        }
    }

    public void on_GAP_TerminateLink(int nowStatus, ConnHandleResult tmpConnResult) {
        if (slaves == null || slaves.size() == 0) {
            return;
        }
        System.err.println("on_GAP_TerminateLink.ConcurrentModificationException slave.size:" + slaves.size());
        for (BleClient mClient : slaves) {
            if (mClient.getConnID() != tmpConnResult.ConnID) continue;
            mClient.onConnectionStateChange(nowStatus);
        }
    }

    public void on_ATT_HandleValueNotification(ConnHandleResult tmpConnResult, int nowStatus, byte[] data) {
        for (BleClient mClient : slaves) {
            if (mClient.getConnID() != tmpConnResult.ConnID) continue;
            mClient.onCharacteristicChanged(tmpConnResult, nowStatus, data);
        }
    }

    public void on_ATT_ExecuteWriteRsp(int nowStatus, ConnHandleResult tmpConnResult) {
        for (BleClient mClient : slaves) {
            if (mClient.getConnID() != tmpConnResult.ConnID) continue;
            mClient.onCharacteristicWrite(nowStatus);
        }
    }

    public void on_ATT_ReadRsp(int nowStatus, byte[] readArr, ConnHandleResult tmpConnResult) {
        for (BleClient mClient : slaves) {
            if (mClient.getConnID() != tmpConnResult.ConnID) continue;
            mClient.onCharacteristicRead(nowStatus, readArr);
        }
    }

    public void on_ATT_ReadByTypeRsp(int nowStatus, byte[] readArr, ConnHandleResult tmpConnResult) {
        this.on_ATT_ReadRsp(nowStatus, readArr, tmpConnResult);
    }
}

