/*
 * Decompiled with CFR 0.152.
 */
package model;

public class BleSeriesInfo {
    public static final int NONMATCH = -1;
    public static final int B35 = 35;
    public static final int B33 = 33;
    public static final int B41 = 41;
    public static final int OW18_16 = 18;
    public static final int OW18E = 20;
    public static final int OW55 = 55;
    private int series;
    private int powerLeft;
    private byte[] firmwareVersion;
    private boolean isSupportFlashRecord;
    private boolean isSurportBattaryPost;
    private boolean isSurportRenameDevice;
    private boolean isSurportOfflineDate;
    private boolean isOnFlashRecord;
    private boolean checkIdOnce;

    public BleSeriesInfo() {
        this.init();
    }

    public void init() {
        byte[] b = new byte[3];
        this.setSeries(-1);
        this.setBattaryPostSupportable(-1);
        this.readFirmwareVersion(b);
        this.setFlashRecordSupportable(false);
        this.setOnFlashRecordStatus(false);
    }

    public boolean isCheckIdOnce() {
        return this.checkIdOnce;
    }

    public void setCheckIdOnce(boolean b) {
        this.checkIdOnce = b;
    }

    public int getSeriesID() {
        return this.series;
    }

    public void setSeries(int type) {
        this.series = type;
    }

    public int getPowerLeft() {
        return this.powerLeft;
    }

    public boolean isB33() {
        return this.series == 33;
    }

    public boolean isB41() {
        return this.series == 41;
    }

    public boolean isOW18() {
        return this.series == 18;
    }

    public boolean isOW55() {
        return this.series == 55;
    }

    public boolean isOWSeries() {
        return this.series == 18 || this.series == 20 || this.series == 55;
    }

    public boolean authorizedSerie() {
        switch (this.series) {
            case 18: 
            case 33: 
            case 35: 
            case 41: 
            case 55: {
                return true;
            }
        }
        return false;
    }

    public void readFirmwareVersion(byte[] vs) {
        this.firmwareVersion = vs;
        int vsValue = vs[0] * 100 + vs[1] * 10 + vs[2];
        this.isSurportRenameDevice = vsValue >= 11;
        this.isSurportOfflineDate = vsValue >= 12;
    }

    public String getFirmwareVersionLabel() {
        String firmVersion = String.valueOf(this.firmwareVersion[0]) + "." + this.firmwareVersion[1] + "." + this.firmwareVersion[2];
        return firmVersion;
    }

    public void setFlashRecordSupportable(boolean surport) {
        this.isSupportFlashRecord = surport;
    }

    public void setBattaryPostSupportable(int powerLeft) {
        boolean supportBat;
        this.powerLeft = powerLeft;
        this.isSurportBattaryPost = supportBat = powerLeft >= 0 && powerLeft <= 100;
    }

    public void setOnFlashRecordStatus(boolean on) {
        this.isOnFlashRecord = on;
    }

    public boolean isSupportFlashRecord() {
        return this.isSupportFlashRecord;
    }

    public boolean isOnFlashRecording() {
        return this.isOnFlashRecord;
    }

    public boolean isSupportBattaryPost() {
        if (!this.isSupportFlashRecord) {
            return false;
        }
        return this.isSurportBattaryPost;
    }

    public boolean isSupportRenameDevice() {
        return this.isSurportRenameDevice;
    }

    public boolean isSurportOfflineDate() {
        return this.isSurportOfflineDate;
    }

    public boolean isUsingB35ChipProtocol() {
        return this.series == 35 && !this.isSupportFlashRecord;
    }
}

