/*
 * Decompiled with CFR 0.152.
 */
package kernal;

import main.Platform;
import model.ConnHandleResult;
import model.DiscoverResult;

public class Event {
    public static final int GAP_HCI_ExtentionCommandStatus = 1663;
    public static final int GAP_DeviceInitDone = 1536;
    public static final int GAP_DeviceInformation = 1549;
    public static final int GAP_DeviceDiscoveryDone = 1537;
    public static final int GAP_EstablishLink = 1541;
    public static final int GAP_TerminateLink = 1542;
    public static final int ATT_HandleValueNotification = 1307;
    public static final int ATT_ExecuteWriteRsp = 1305;
    public static final int ATT_ReadRsp = 1291;
    public static final int ATT_WriteRsp = 1299;
    public static final int ATT_ReadByTypeRsp = 1289;
    public static final int EventType_Scan_Response = 4;
    public static final int EventType_Connectable_Undirect_Advertisement = 0;
    public static final int Status_Already_Performing_That_Task = 17;
    public static boolean sDebug = false;
    public static boolean onDebugHead = false;
    public static boolean onDebugDump = false;
    public static boolean onDebugNotification = false;
    public static final int GAP_EstablishLinkRequest = 65033;
    public static final int Success = 0;

    public static int name(byte b1, byte b2) {
        return Event.toShort(b1, b2);
    }

    public static int toShort(byte b1, byte b2) {
        int low = b1 & 0xFFFF;
        int high = b2 << 8 & 0xFFFF;
        return high | low;
    }

    public static boolean GAP_HCI_ExtentionCommandStatus_handle(byte[] buf, int p, int structLen) {
        if (buf.length != structLen + 3) {
            System.err.println("Event.GAP_HCI_ExtentionCommandStatus_handle.bufLen Error\nbufLen:" + buf.length + ",structLen:" + structLen);
        }
        byte status = buf[p++];
        int opCode = Event.toShort(buf[p++], buf[p++]);
        byte dataLength = buf[p++];
        if (status == 17) {
            Platform.getBle().broadcast.sendBroadcast_AlreadyPerformingThatTask(null, status);
        }
        Event.println(" Event\t\t: 0x067F (1663) (GAP_HCI_ExtentionCommandStatus)");
        Event.println2x(" Status\t\t: ", status);
        Event.println4x(" OpCode\t\t: ", opCode);
        Event.println2x(" DataLength\t: ", dataLength);
        if (dataLength > 0) {
            int paramValue = Event.toShort(buf[p++], buf[p++]);
            Event.println4x(" ParamValue\t: ", paramValue);
        }
        return status == 0;
    }

    public static byte[] ATT_HandleValueNotification_handle(byte[] buf, int p, int structLen, ConnHandleResult tmpResult) {
        byte status = buf[p++];
        tmpResult.setResult(buf[p++], buf[p++], null);
        int connHandle = tmpResult.ConnID;
        byte pduLen = buf[p++];
        int handle = Event.toShort(buf[p++], buf[p++]);
        byte[] value = new byte[pduLen - 2];
        System.arraycopy(buf, p, value, 0, value.length);
        if (onDebugNotification) {
            Event.println(" Event\t: 0x051B (1307) (ATT_HandleValueNotification)");
            Event.println2x(" Status\t\t:", status);
            Event.println4x(" ConnHandle\t:", connHandle);
            Event.println2x(" PduLen\t\t:", pduLen);
            Event.println4x(" Handle\t\t:", handle);
            Event.println2xLink(" Value\t\t:  ", value);
        }
        if (status != 0) {
            return null;
        }
        return value;
    }

    public static boolean GAP_DeviceInitDone_handle(byte[] buf, int p, int structLen) {
        byte status = buf[p++];
        byte[] devAddr = new byte[6];
        int i = devAddr.length - 1;
        while (i >= 0) {
            devAddr[i] = buf[p++];
            --i;
        }
        int dataPktLen = Event.toShort(buf[p++], buf[p++]);
        byte numDataPkts = buf[p++];
        byte[] IRK = new byte[16];
        byte[] CSRK = new byte[16];
        System.arraycopy(buf, p, IRK, 0, IRK.length);
        System.arraycopy(buf, p += IRK.length, CSRK, 0, structLen - p - 1);
        Event.println(" Event\t\t:  0x0600 (1536) (GAP_DeviceInitDone)");
        Event.println2x(" Status\t\t:  ", status);
        Event.println2xLink(" DevAddr\t:  ", devAddr);
        Event.println4x(" DataPktLen\t:  ", dataPktLen);
        Event.println2x(" NumDataPkts\t:  ", numDataPkts);
        Event.println2xLink(" IRK\t\t:  ", IRK);
        Event.println2xLink(" CSRK\t\t:  ", CSRK);
        return status == 0;
    }

    public static boolean GAP_DeviceInformation_handle(byte[] buf, int p, int structLen) {
        byte status = buf[p++];
        byte eventType = buf[p++];
        byte addrType = buf[p++];
        byte[] addr = new byte[6];
        int i = 0;
        int len = addr.length;
        while (i < len) {
            addr[i] = buf[p++];
            ++i;
        }
        byte rssi = buf[p++];
        byte dataLength = buf[p++];
        byte[] data = new byte[dataLength];
        int i2 = 0;
        while (i2 < data.length) {
            if (p < structLen + 3) {
                data[i2] = buf[p++];
            }
            ++i2;
        }
        DiscoverResult r = new DiscoverResult();
        if (status == 0) {
            r.addr = addr;
            int i3 = addr.length - 1;
            while (i3 >= 0) {
                r.addrName = String.valueOf(r.addrName) + String.format("%02X", addr[i3]);
                if (i3 != 0) {
                    r.addrName = String.valueOf(r.addrName) + ":";
                }
                --i3;
            }
            r.rssi = rssi;
            r.devName = "";
            Platform.getBle().broadcast.sendScanDeviceInfoBroadcast(null, r);
        }
        Event.println(" Event\t\t: 0x060D (1549) (GAP_DeviceInformation)");
        Event.println2x(" Status\t\t:  ", status);
        Event.println2x(" EventType\t:  ", eventType);
        Event.println2x(" AddrType\t:  ", addrType);
        Event.println2xLink(" Addr\t\t:  ", addr);
        Event.println2x(" Rssi\t\t:  ", rssi);
        Event.println2x(" DataLength\t:  ", dataLength);
        Event.println2xLink(" Data\t\t:  ", data);
        return status == 0;
    }

    public static DiscoverResult[] GAP_DeviceDiscoveryDone_handle(byte[] buf, int p, int structLen) {
        byte status = buf[p++];
        int numDevs = buf[p++];
        Event.println(" Event\t\t: 0x0601 (1537) (GAP_DeviceDiscoveryDone)");
        Event.println2x(" Status\t\t: ", status);
        Event.println2x(" NumDevs\t: ", numDevs);
        DiscoverResult[] slaveAddrs = new DiscoverResult[numDevs];
        int idx = 0;
        while (idx < numDevs) {
            Event.println(" Device #" + idx);
            byte eventType = buf[p++];
            byte addrType = buf[p++];
            byte[] addr = new byte[6];
            int i = 0;
            int len = addr.length;
            while (i < len) {
                addr[i] = buf[p++];
                ++i;
            }
            Event.println2x(" EventType\t: ", eventType);
            Event.println2x(" AddrType\t: ", addrType);
            Event.println2xLink(" Addr\t: ", addr);
            slaveAddrs[idx] = new DiscoverResult();
            slaveAddrs[idx].addr = addr;
            i = addr.length - 1;
            while (i >= 0) {
                slaveAddrs[idx].addrName = String.valueOf(slaveAddrs[idx].addrName) + String.format("%02X", addr[i]);
                if (i != 0) {
                    slaveAddrs[idx].addrName = String.valueOf(slaveAddrs[idx].addrName) + ":";
                }
                --i;
            }
            ++idx;
        }
        if (status != 0) {
            return null;
        }
        return slaveAddrs;
    }

    public static boolean GAP_EstablishLink_handle(byte[] buf, int p, int structLen, ConnHandleResult tmpResult) {
        byte status = buf[p++];
        byte devAddrType = buf[p++];
        byte[] devAddr = new byte[6];
        int i = devAddr.length - 1;
        while (i >= 0) {
            devAddr[i] = buf[p++];
            --i;
        }
        tmpResult.setResult(buf[p++], buf[p++], devAddr);
        int connHandle = tmpResult.ConnID;
        byte connRole = buf[p++];
        int connInterval = Event.toShort(buf[p++], buf[p++]);
        int connLatency = Event.toShort(buf[p++], buf[p++]);
        int connTimeout = Event.toShort(buf[p++], buf[p++]);
        Event.println(" Event\t\t: 0x0605 (1541) (GAP_EstablishLink)");
        Event.println2x(" Status\t\t:  ", status);
        Event.println2x(" DevAddrType\t:  ", devAddrType);
        Event.println2xLink(" DevAddr\t\t: ", devAddr);
        Event.println4x(" ConnHandle\t:", connHandle);
        Event.println2x(" ConnRole\t:  ", connRole);
        Event.println4x(" ConnInterval\t:", connInterval);
        Event.println4x(" ConnLatency\t:", connLatency);
        Event.println4x(" ConnTimeout\t:", connTimeout);
        if (p < buf.length) {
            byte clockAccuracy = buf[p];
            Event.println2x(" ClockAccuracy\t\t:  ", clockAccuracy);
        }
        return status == 0;
    }

    public static boolean GAP_TerminateLink_handle(byte[] buf, int p, int structLen, ConnHandleResult tmpResult) {
        byte status = buf[p++];
        tmpResult.setResult(buf[p++], buf[p++], null);
        int connHandle = tmpResult.ConnID;
        byte reason = buf[p++];
        Event.println(" Event\t\t: 0x0606 (1542) (GAP_TerminateLink)");
        Event.println2x(" Status\t\t:  ", status);
        Event.println4x(" ConnHandle\t:", connHandle);
        Event.println2x(" Reason\t\t:  ", reason);
        return status == 0;
    }

    public static boolean ATT_ExecuteWriteRsp_handle(byte[] buf, int p, int event, ConnHandleResult tmpResult) {
        byte status = buf[p++];
        tmpResult.setResult(buf[p++], buf[p++], null);
        int connHandle = tmpResult.ConnID;
        byte pduLen = buf[p++];
        String eventId = event == 1305 ? "0x0519 (1305) (" : " 0x0513 (1299) (ATT_WriteRsp)";
        String eventStr = event == 1305 ? "ATT_ExecuteWriteRsp" : "ATT_WriteRsp";
        Event.println(" Event\t\t:" + eventId + eventStr + ")");
        Event.println2x(" Status\t\t:", status);
        Event.println4x(" ConnHandle\t:", connHandle);
        Event.println2x(" PduLen\t\t:", pduLen);
        return status == 0;
    }

    public static byte[] ATT_ReadRsp_handle(byte[] buf, int p, int structLen, ConnHandleResult tmpResult) {
        byte status = buf[p++];
        tmpResult.setResult(buf[p++], buf[p++], null);
        int connHandle = tmpResult.ConnID;
        byte pduLen = buf[p++];
        byte[] value = new byte[pduLen];
        System.arraycopy(buf, p, value, 0, pduLen);
        p += pduLen;
        Event.println("Event\t\t: 0x050B (1291) (ATT_ReadRsp)");
        Event.println2x(" Status\t\t:  ", status);
        Event.println4x(" ConnHandle\t:", connHandle);
        Event.println2x(" PduLen\t\t:  ", pduLen);
        Event.println2xLink(" Value\t\t", value);
        if (status != 0) {
            return null;
        }
        return value;
    }

    public static byte[] ATT_ReadByTypeRsp(byte[] buf, int p, int structLen, ConnHandleResult tmpResult) {
        byte status = buf[p++];
        tmpResult.setResult(buf[p++], buf[p++], null);
        int connHandle = tmpResult.ConnID;
        byte pduLen = buf[p++];
        byte length = buf[p++];
        int handle = Event.toShort(buf[p++], buf[p++]);
        byte[] data = new byte[length - 2];
        System.arraycopy(buf, p, data, 0, data.length);
        p += data.length;
        Event.println("Event\t\t: 0x0509 (1289) (ATT_ReadByTypeRsp)");
        Event.println2x(" Status\t\t:  ", status);
        Event.println4x(" ConnHandle\t:", connHandle);
        Event.println2x(" PduLen\t\t:  ", pduLen);
        Event.println2x(" Length\t\t:  ", length);
        Event.println4x(" Handle\t\t:", handle);
        Event.println2xLink(" Value\t\t", data);
        if (status != 0) {
            return null;
        }
        return data;
    }

    public static void println(String tag) {
        if (sDebug) {
            System.out.println(tag);
        }
    }

    public static void println2x(String tag, Object value) {
        if (sDebug) {
            System.out.println(String.valueOf(tag) + String.format("0x%02X", value));
        }
    }

    public static void println4x(String tag, Object value) {
        if (sDebug) {
            System.out.println(String.valueOf(tag) + String.format("0x%04X", value));
        }
    }

    public static void println2xLink(String tag, byte[] arr) {
        if (sDebug) {
            System.out.print(tag);
            int i = 0;
            int len = arr.length;
            while (i < len) {
                if (i < len - 1) {
                    System.out.print(String.valueOf(String.format("%02X", arr[i])) + ":");
                } else {
                    System.out.print(String.valueOf(String.format("%02X", arr[i])) + "\n\n");
                }
                ++i;
            }
        }
    }

    public static String get2xLink(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int len = arr.length;
        while (i < len) {
            if (i < len - 1) {
                sb.append(String.valueOf(String.format("%02X", arr[i])) + ":");
            } else {
                sb.append(String.valueOf(String.format("%02X", arr[i])) + "\n\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public static void printlnDump(int readlen, String s) {
        if (onDebugDump) {
            System.out.println("Dump(Rn):(" + readlen + ")\n" + s + "\n\n");
        }
    }
}

