/*
 * Decompiled with CFR 0.152.
 */
package kernal;

import control.BroadcastAgent;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import kernal.BleClient;
import kernal.Command;
import kernal.Event;
import main.Platform;
import model.BleClientGattCallback;
import model.BleSlaveManager;
import model.ConnHandleResult;
import model.DiscoverResult;
import storeroom.util.ByteUtil;

public class BleAgent
implements Runnable,
SerialPortEventListener {
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTED = 1;
    public static final int STATE__SUCESS = 2;
    public static final int STATE__ERROR = 3;
    private String UserSelectedPort = "";
    private int baud = 115200;
    public BroadcastAgent broadcast = new BroadcastAgent();
    private BleSlaveManager slaveManager = new BleSlaveManager();
    CommPortIdentifier portId;
    Enumeration portList;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Thread readThread;
    private SerialPort serialPort;

    public void setUserSelectedPort(String port) {
        this.UserSelectedPort = port;
    }

    @Override
    public void run() {
        String result;
        this.portList = CommPortIdentifier.getPortIdentifiers();
        while (this.portList.hasMoreElements()) {
            this.portId = (CommPortIdentifier)this.portList.nextElement();
            if (this.portId.getPortType() != 1 || !this.portId.getName().equals(this.UserSelectedPort)) continue;
            try {
                this.serialPort = (SerialPort)this.portId.open("MyCommCC2540", 2000);
                result = "OPEND PORT " + this.portId.getName();
                this.broadcast.sendBroadcast_PortFound(true, result);
                System.err.println("BleAgent." + result);
            }
            catch (PortInUseException e) {
                e.printStackTrace();
            }
            this.initPort();
            this.initBleHciRequest();
            break;
        }
        if (this.serialPort == null) {
            result = "Can not open port " + this.UserSelectedPort;
            this.broadcast.sendBroadcast_PortFound(false, result);
            System.err.println(result);
            return;
        }
    }

    private void initPort() {
        try {
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.serialPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        try {
            this.serialPort.setSerialPortParams(this.baud, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        this.serialPort.notifyOnDataAvailable(true);
    }

    private boolean sendCommand(byte[] command, String event) {
        if (this.outputStream == null) {
            System.err.println("outputStream null");
            return false;
        }
        try {
            this.outputStream.write(command);
            this.outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        StringBuilder sb = new StringBuilder();
        byte[] byArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X ", b));
            ++n2;
        }
        this.broadcast.sendActionBroadcast(null, "Wr:" + event + "\t" + sb.toString() + "\n\n");
        Command.println("Wr:" + event + "\t" + sb.toString() + "\n");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void initBleHciRequest() {
        this.sendCommand(Command.initcmd(), "initcmd");
    }

    private void initHandleServices() {
    }

    public void openSeriesPort() {
        this.readThread = new Thread(this);
        this.readThread.start();
    }

    public void discoveryRequest() {
        this.sendCommand(Command.discoveryRequest(), "discoveryRequest");
    }

    public boolean linkRequest(DiscoverResult slave, BleClientGattCallback bleCallback) {
        boolean success = BleSlaveManager.onCreateClient(slave.addrName, bleCallback);
        if (success) {
            this.sendCommand(Command.linkRequest(slave.addr), "linkRequest");
        } else {
            System.err.println("it had this connection already");
        }
        return success;
    }

    @Deprecated
    public void terminateLinkRequest(BleClient client) {
        BleSlaveManager.onPopupClient(client);
        if (client != null) {
            byte[] connHandle = client.getConnHandle().getConnArr();
            if (connHandle != null) {
                this.sendCommand(Command.terminateLinkRequest(connHandle), "Terminate");
            } else {
                System.err.println("connHandle is null");
            }
        } else {
            System.err.println("can`t find the slave,cannot stop");
        }
    }

    public void terminateLinkRequest(byte[] connHandle) {
        if (connHandle != null) {
            this.sendCommand(Command.terminateLinkRequest(connHandle), "Terminate");
        } else {
            System.err.println("connHandle is null");
        }
    }

    public void writeRequest(byte[] cmds) {
        this.sendCommand(cmds, "writeRequest");
    }

    public void readRequest(byte[] cmds) {
        this.sendCommand(cmds, "readRequest");
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 10: {
                System.out.println("BI");
                break;
            }
            case 7: {
                System.out.println("OE");
                break;
            }
            case 9: {
                System.out.println("FE");
                break;
            }
            case 8: {
                System.out.println("PE");
                break;
            }
            case 6: {
                System.out.println("CD");
                break;
            }
            case 3: {
                System.out.println("CTS");
                break;
            }
            case 4: {
                System.out.println("DSR");
                break;
            }
            case 5: {
                System.out.println("RI");
                break;
            }
            case 2: {
                System.out.println("OUTPUT_BUFFER_EMPTY");
                break;
            }
            case 1: {
                this.dealAvailableData();
            }
        }
    }

    private void dealAvailableData() {
        try {
            byte[] buf = ByteUtil.readInputStreamToBuf(this.inputStream);
            this.distinguishRespondType(buf);
        }
        catch (IOException iOException) {}
    }

    private void distinguishRespondType(byte[] buf) {
        String hexStr = ByteUtil.getBytesHexStr(buf);
        this.broadcast.sendActionBroadcast(null, "Rn:(" + buf.length + ")\n" + hexStr + "\n\n");
        Event.printlnDump(buf.length, hexStr);
        ConnHandleResult tmpConnResult = new ConnHandleResult();
        int p = 0;
        byte type = buf[p++];
        byte eventCode = buf[p++];
        byte dataLength = buf[p++];
        if (Event.onDebugHead) {
            Event.println2x("-Type\t:", type);
            Event.println2x("-EventCode\t:", eventCode);
            Event.println2x("-Data Length\t:", dataLength);
        }
        int nowStatus = -1;
        int event = Event.name(buf[p++], buf[p++]);
        switch (event) {
            case 1663: {
                boolean result = Event.GAP_HCI_ExtentionCommandStatus_handle(buf, p, dataLength);
                break;
            }
            case 1536: {
                boolean result = Event.GAP_DeviceInitDone_handle(buf, p, dataLength);
                this.broadcast.sendBroadcast_DeviceInitResult(null, result);
                break;
            }
            case 1549: {
                boolean result = Event.GAP_DeviceInformation_handle(buf, p, dataLength);
                break;
            }
            case 1537: {
                boolean result;
                DiscoverResult[] slaveDevs = Event.GAP_DeviceDiscoveryDone_handle(buf, p, dataLength);
                boolean bl = result = slaveDevs != null;
                if (slaveDevs == null || slaveDevs.length <= 0) break;
                Platform.getBle().broadcast.sendEnableLinkBroadcast(null, slaveDevs);
                break;
            }
            case 1541: {
                boolean result = Event.GAP_EstablishLink_handle(buf, p, dataLength, tmpConnResult);
                nowStatus = result ? 1 : 0;
                this.slaveManager.on_GAP_EstablishLink(nowStatus, tmpConnResult);
                break;
            }
            case 1542: {
                boolean result = Event.GAP_TerminateLink_handle(buf, p, dataLength, tmpConnResult);
                nowStatus = result ? 0 : 1;
                this.slaveManager.on_GAP_TerminateLink(nowStatus, tmpConnResult);
                break;
            }
            case 1307: {
                byte[] data = Event.ATT_HandleValueNotification_handle(buf, p, dataLength, tmpConnResult);
                boolean result = data != null;
                this.slaveManager.on_ATT_HandleValueNotification(tmpConnResult, this.nowStatus(result), data);
                break;
            }
            case 1305: {
                boolean result = Event.ATT_ExecuteWriteRsp_handle(buf, p, event, tmpConnResult);
                this.slaveManager.on_ATT_ExecuteWriteRsp(this.nowStatus(result), tmpConnResult);
                break;
            }
            case 1291: {
                byte[] readArr = Event.ATT_ReadRsp_handle(buf, p, dataLength, tmpConnResult);
                boolean result = readArr != null;
                this.slaveManager.on_ATT_ReadRsp(this.nowStatus(result), readArr, tmpConnResult);
                break;
            }
            case 1299: {
                boolean result = Event.ATT_ExecuteWriteRsp_handle(buf, p, event, tmpConnResult);
                this.slaveManager.on_ATT_ExecuteWriteRsp(this.nowStatus(result), tmpConnResult);
                break;
            }
            case 1289: {
                byte[] readByTypeArr = Event.ATT_ReadByTypeRsp(buf, p, dataLength, tmpConnResult);
                boolean result = readByTypeArr != null;
                this.slaveManager.on_ATT_ReadByTypeRsp(this.nowStatus(result), readByTypeArr, tmpConnResult);
            }
        }
        int exhaustLen = 3 + dataLength;
        if (buf.length > exhaustLen) {
            int remainingLen = buf.length - exhaustLen;
            byte[] tailArr = new byte[remainingLen];
            System.arraycopy(buf, exhaustLen, tailArr, 0, remainingLen);
            this.distinguishRespondType(tailArr);
        }
    }

    private int nowStatus(boolean result) {
        return result ? 2 : 3;
    }

    public BleClient getClient() {
        return BleSlaveManager.getSelectedClient();
    }

    public void release() {
        this.broadcast.unRegisterListeners();
        BleSlaveManager.onPopupAll();
        try {
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.serialPort != null && this.portId != null && this.portId.isCurrentlyOwned()) {
                    this.serialPort.close();
                }
            }
        }
        finally {
            if (this.serialPort != null && this.portId != null && this.portId.isCurrentlyOwned()) {
                this.serialPort.close();
            }
        }
    }
}

