/*
 * Decompiled with CFR 0.152.
 */
package frame.view;

import control.ChartControl;
import frame.i18n.StringRes;
import frame.utill.FadeIOShell;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import org.jfree.chart.ChartPanel;
import org.jfree.data.xy.XYSeries;
import storeroom.draw.Draw;

public class ChartPage
extends JPanel
implements PropertyChangeListener {
    JList mList;
    JComboBox mDeviceList;
    JScrollPane scrollPane;
    DefaultComboBoxModel deviceListMode;
    ChartControl chartCtr;
    Window mContext;
    String mAddress = "";
    BleClient current;
    Dimension d = new Dimension(512, 576);
    boolean mPlayStatus = true;
    private final String TAG = "ChartPage";

    public ChartPage() {
        this.chartCtr = Platform.getMain().getChartCtr();
        this.setLayout(new BorderLayout());
        this.createWavePane();
        this.createListPane();
        BleAgent ag = Platform.getBle();
        ag.broadcast.addProperty(this);
    }

    private void createWavePane() {
        ChartPanel chart = this.chartCtr.getChartPanel();
        this.add((Component)chart, "Center");
    }

    private void createListPane() {
        JPanel listP = new JPanel();
        listP.setLayout(new BorderLayout());
        this.add((Component)listP, "East");
        JPanel deviceListP = new JPanel();
        deviceListP.setPreferredSize(new Dimension(250, 45));
        deviceListP.setBackground(Color.GRAY);
        listP.add((Component)deviceListP, "North");
        this.mDeviceList = new JComboBox();
        this.mDeviceList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ChartPage.this.updateDataList();
                }
            }
        });
        deviceListP.add(this.mDeviceList);
        JMenuBar bar = new JMenuBar();
        bar.setSize(new Dimension(0, 30));
        deviceListP.add(bar);
        JMenu funcMenu = new JMenu(StringRes.getString("chart.funcBtn"));
        bar.add(funcMenu);
        JMenuItem saveItem = new JMenuItem(StringRes.getString("chart.saveBtn"));
        JMenuItem clearItem = new JMenuItem(StringRes.getString("chart.clearBtn"));
        JCheckBoxMenuItem scrollItem = new JCheckBoxMenuItem(StringRes.getString("chart.autoScroll"));
        scrollItem.setSelected(this.mPlayStatus);
        JCheckBoxMenuItem singletonItem = new JCheckBoxMenuItem(StringRes.getString("chart.singleton"));
        singletonItem.setSelected(this.chartCtr.singletonAllow);
        funcMenu.add(saveItem);
        funcMenu.add(clearItem);
        funcMenu.add(scrollItem);
        funcMenu.add(singletonItem);
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String osName = System.getProperty("os.name");
                String tips = StringRes.getString("chart.saveTips");
                if (osName.contains("10")) {
                    FadeIOShell fs = new FadeIOShell();
                    fs.prompt(tips, ChartPage.this.mContext);
                }
                ChartPage.this.chartCtr.saveReceiveData(ChartPage.this.current);
            }
        });
        clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartPage.this.chartCtr.clearClient(ChartPage.this.current);
            }
        });
        scrollItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartPage.this.mPlayStatus = !ChartPage.this.mPlayStatus;
            }
        });
        singletonItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartPage.this.chartCtr.singletonAllow = !ChartPage.this.chartCtr.singletonAllow;
            }
        });
        this.mList = new JList();
        this.mList.setBackground(Draw.chartBg);
        this.scrollPane = new JScrollPane(this.mList);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setBorder(null);
        this.scrollPane.setOpaque(false);
        listP.add((Component)this.scrollPane, "Center");
    }

    public void initChartListModel() {
        this.chartCtr.initClientsSeries();
    }

    public void updateDeviceList() {
        this.deviceListMode = this.chartCtr.loadDeviceListMode();
        this.mDeviceList.setModel(this.deviceListMode);
    }

    public void updateDataList() {
        int sel = this.mDeviceList.getSelectedIndex();
        this.current = BleSlaveManager.getClient(sel);
        if (this.current == null) {
            return;
        }
        this.current.getDevName();
        String addr = this.current.getAddress();
        if (addr != null) {
            this.mAddress = addr;
            DefaultListModel datalist = this.chartCtr.getDataModel(addr);
            if (datalist != null) {
                this.mList.setModel(datalist);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pn = evt.getPropertyName();
        Object o = evt.getNewValue();
        if (o == null) {
            return;
        }
        if (pn.equals("data.broadcast")) {
            MultimeterReceivedData receivedData = (MultimeterReceivedData)o;
            this.receiveDataAddToDataList(receivedData);
        }
    }

    private void receiveDataAddToDataList(MultimeterReceivedData data) {
        if (data.Index == -1) {
            this.MSG_ERROR("Handle ACTION_DATA_RECEIVED,invalid Index");
            return;
        }
        XYSeries series = this.chartCtr.getXYSeries(data.mAddress);
        DefaultListModel datalist = this.chartCtr.getDataModel(data.mAddress);
        if (datalist == null || series == null) {
            this.MSG_ERROR("Handle ACTION_DATA_RECEIVED, series/datalist/adapter not found");
        } else {
            series.add((double)data.Index, data.Value);
            this.chartCtr.repaintChartPanel();
            datalist.addElement(this.chartCtr.getFormateData(data));
            if (this.mPlayStatus && this.mAddress.equals(data.mAddress)) {
                this.mList.validate();
                String cfr_ignored_0 = data.mAddress;
                this.mList.ensureIndexIsVisible(data.Index);
                this.mList.repaint();
            }
            this.chartCtr.setLegendTitle(series, data.Unit);
            this.chartCtr.keepSingleton(datalist, data);
        }
    }

    public void setWinContext(Window mContext) {
        this.mContext = mContext;
    }

    private void MSG_ERROR(String msg) {
        System.err.println("[ ChartPage ] :: Error :: " + msg);
    }

    private void MSG_DEBUG(String msg) {
        System.out.println("dbg[ ChartPage ] $$$:: " + msg);
    }
}

