/*
 * Decompiled with CFR 0.152.
 */
package frame.utill;

import com.sun.awt.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class NoticeDialog
extends JDialog {
    public static final int arc = 6;
    public static final int msgNum = 2;
    public static final Font font = new Font("SansSerif", 1, 15);
    public static final Color CO_FADE_BG = new Color(60, 60, 60);
    private String msg = "";
    private boolean out;

    public NoticeDialog(Window owner) {
        super(owner);
        this.setLayout(new BorderLayout());
        if (owner != null) {
            owner.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    NoticeDialog.this.dispose();
                }
            });
        }
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        JPanel jp = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                int w = this.getWidth();
                int h = this.getHeight();
                int wc = w >> 1;
                int hc = h >> 1;
                g2d.setFont(font);
                FontMetrics fm = g2d.getFontMetrics();
                Rectangle2D r2d = fm.getStringBounds(NoticeDialog.this.msg, this.getGraphics());
                int tw = (int)r2d.getWidth();
                int th = (int)r2d.getHeight();
                int x = wc - (tw >> 1);
                int y = hc - (th >> 1);
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(CO_FADE_BG);
                g2d.fillRoundRect(2, 2, w - 5, h - 5, 6, 6);
                g2d.setColor(Color.WHITE);
                g2d.drawString(NoticeDialog.this.msg, x, y + fm.getAscent());
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        this.add((Component)jp, "Center");
        this.setFont(font);
        AWTUtilities.setWindowOpaque((Window)this, (boolean)false);
        this.setLocationRelativeTo(null);
        AWTUtilities.setWindowOpacity((Window)this, (float)0.75f);
    }

    private void recomputeDialgSize() {
        FontMetrics fm = this.getFontMetrics(font);
        Rectangle2D r2d = fm.getStringBounds(this.msg, this.getGraphics());
        this.setSize((int)r2d.getWidth() + 30, (int)r2d.getHeight() + 30);
        this.setLocationRelativeTo(null);
    }

    public void setMessage(String m) {
        this.msg = m;
        this.recomputeDialgSize();
    }

    public void keepShow() {
        this.keepShow(2000);
    }

    public void keepShow(final int time) {
        new Thread(){

            @Override
            public void run() {
                NoticeDialog.this.nofading(time);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nofading(int time) {
        this.setVisible(true);
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        NoticeDialog noticeDialog = this;
        synchronized (noticeDialog) {
            this.dispose();
        }
    }

    private void fading() {
        float v = 0.0f;
        this.out = false;
        AWTUtilities.setWindowOpacity((Window)this, (float)(v += 0.1f));
        this.setVisible(true);
        try {
            while ((double)v < 0.85 && !this.out) {
                AWTUtilities.setWindowOpacity((Window)this, (float)v);
                v += 0.1f;
                Thread.sleep(170L);
            }
            Thread.sleep(1000L);
            v -= 0.2f;
            while ((double)v > 0.5 && !this.out) {
                AWTUtilities.setWindowOpacity((Window)this, (float)v);
                v -= 0.06f;
                Thread.sleep(260L);
            }
            while (v > 0.0f && !this.out) {
                AWTUtilities.setWindowOpacity((Window)this, (float)v);
                v -= 0.08f;
                Thread.sleep(180L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.dispose();
    }
}

