/*
 * Decompiled with CFR 0.152.
 */
package frame;

import frame.i18n.StringRes;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kernal.BleAgent;
import kernal.BleClient;
import kernal.HexCmds;
import main.Platform;
import model.BleSlaveManager;

public class RecordSetDialog
extends JDialog {
    BleAgent ag;
    private static RecordSetDialog setDlg;
    JLabel tipsLbl;
    JLabel time;
    JTextField intervalTf;
    JTextField countTf;
    JButton startBtn;
    boolean hasStartToRecord;

    public static RecordSetDialog getInstance(JFrame main) {
        if (setDlg == null) {
            setDlg = new RecordSetDialog(main);
        }
        return setDlg;
    }

    public RecordSetDialog(JFrame main) {
        super(main);
        this.setSize(new Dimension(500, 299));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                setDlg = null;
            }
        });
        this.initDialog();
        this.ag = Platform.getBle();
    }

    private void initDialog() {
        Container c = this.getContentPane();
        this.setLayout(new BoxLayout(c, 1));
        JPanel tipsP = new JPanel();
        JPanel intervalP = new JPanel();
        JPanel countP = new JPanel();
        JPanel costtimeP = new JPanel();
        JPanel btnP = new JPanel();
        this.tipsLbl = new JLabel(StringRes.getString("recordSetDlg.tips1"));
        tipsP.add(this.tipsLbl);
        JLabel intervalLbl = new JLabel(StringRes.getString("recordSetDlg.interval"));
        intervalP.add(intervalLbl);
        this.intervalTf = new JTextField();
        this.intervalTf.setColumns(20);
        intervalP.add(this.intervalTf);
        JLabel unitLbl = new JLabel(StringRes.getString("recordSetDlg.sec"));
        intervalP.add(unitLbl);
        JLabel countLbl = new JLabel(StringRes.getString("recordSetDlg.counts"));
        countP.add(countLbl);
        this.countTf = new JTextField();
        this.countTf.setColumns(11);
        countP.add(this.countTf);
        JLabel maxLbl = new JLabel(StringRes.getString("recordSetDlg.max"));
        countP.add(maxLbl);
        JLabel costTimeLbl = new JLabel(StringRes.getString("recordSetDlg.costTime"));
        costtimeP.add(costTimeLbl);
        this.time = new JLabel();
        costtimeP.add(this.time);
        this.startBtn = new JButton(StringRes.getString("recordSetDlg.start"));
        btnP.add(this.startBtn);
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RecordSetDialog.this.startBtn.getText().equals(StringRes.getString("recordSetDlg.back"))) {
                    RecordSetDialog.this.tryToSetCmd();
                } else {
                    RecordSetDialog.this.dismissDlg();
                }
            }
        });
        this.add(tipsP);
        this.add(intervalP);
        this.add(countP);
        this.add(costtimeP);
        this.add(btnP);
        this.initValue();
    }

    public void showDlg() {
        this.setVisible(true);
    }

    private void initValue() {
        this.hasStartToRecord = false;
        this.intervalTf.setText("1");
        this.countTf.setText("1000");
    }

    private void dismissDlg() {
        this.dispose();
        setDlg = null;
    }

    private void tryToSetCmd() {
        BleClient mClient = this.ag.getClient();
        if (mClient == null) {
            this.MSG_ERROR("onClick.mClient == null ");
            return;
        }
        if (this.hasStartToRecord) {
            this.dispose();
        } else {
            int iv = 0;
            int ln = 0;
            try {
                iv = Integer.parseInt(this.intervalTf.getText());
            }
            catch (Exception exception) {
                iv = 1;
            }
            try {
                ln = Integer.parseInt(this.countTf.getText());
            }
            catch (Exception exception) {
                ln = 10;
            }
            if (iv == 0 || ln == 0) {
                JOptionPane.showMessageDialog(this, "Value need to be bigger than zero");
            } else {
                this.sendSettingCmd_disconnect(mClient, iv, ln);
                this.highlightTheDisconnected();
                this.hasStartToRecord = true;
                this.startBtn.setText(StringRes.getString("recordSetDlg.back"));
            }
        }
    }

    private void sendSettingCmd_disconnect(final BleClient mClient, int iv, int ln) {
        HexCmds lib = new HexCmds();
        byte[] cmds = lib.getRecordCmd(iv, ln);
        if (mClient != null) {
            mClient.writeCharacteristic((byte)37, cmds);
            final Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    mClient.disconnect();
                    Platform.getMain().onPopupItem(mClient.getAddress());
                    BleSlaveManager.onPopupClient(mClient);
                    timer.cancel();
                }
            };
            timer.schedule(task, 1000L);
        }
    }

    private void highlightTheDisconnected() {
        this.tipsLbl.setForeground(Color.RED);
        this.tipsLbl.setText(StringRes.getString("recordSetDlg.tips2"));
    }

    private void MSG_ERROR(String msg) {
        System.err.println("err:" + msg);
    }

    public static void main(String[] args) {
        new RecordSetDialog(null).show();
    }
}

