/*
 * Decompiled with CFR 0.152.
 */
package frame;

import frame.i18n.StringRes;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;

public class RecordReadDialog
extends JDialog
implements PropertyChangeListener {
    private static RecordReadDialog readDlg;
    JTextField fileNameLbl;
    JLabel dataLenLbl;
    JButton readBtn;
    JButton openBtn;
    JProgressBar bar;
    String csvPath = "";
    private BleAgent ag;

    public static RecordReadDialog getInstance(JFrame main) {
        if (readDlg == null) {
            readDlg = new RecordReadDialog(main);
        }
        return readDlg;
    }

    private RecordReadDialog(JFrame main) {
        super(main);
        this.setSize(new Dimension(500, 250));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                readDlg = null;
            }
        });
        this.initDialog();
        this.ag = Platform.getBle();
        this.ag.broadcast.addProperty(this);
        BleClient mClient = this.ag.getClient();
        if (mClient != null) {
            mClient.writeCmd_GetOfflineDataSize();
        }
    }

    private void initDialog() {
        Container c = this.getContentPane();
        this.setLayout(new BoxLayout(c, 1));
        JPanel dataLenP = new JPanel();
        JPanel fileNameP = new JPanel();
        JPanel progressP = new JPanel();
        JPanel btnP = new JPanel();
        JLabel lbl1 = new JLabel(StringRes.getString("recordReadDlg.dataLen"));
        dataLenP.add(lbl1);
        this.dataLenLbl = new JLabel(" xxx");
        dataLenP.add(this.dataLenLbl);
        JLabel unitLbl = new JLabel(StringRes.getString("recordReadDlg.bytes"));
        dataLenP.add(unitLbl);
        JLabel lbl2 = new JLabel(StringRes.getString("recordReadDlg.fileName"));
        fileNameP.add(lbl2);
        this.fileNameLbl = new JTextField(StringRes.getString("recordReadDlg.devName"));
        this.fileNameLbl.setColumns(10);
        fileNameP.add(this.fileNameLbl);
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        progressP.add(this.bar);
        this.readBtn = new JButton(StringRes.getString("recordReadDlg.readRec"));
        this.readBtn.setEnabled(false);
        btnP.add(this.readBtn);
        this.openBtn = new JButton(StringRes.getString("recordReadDlg.openDir"));
        this.openBtn.setVisible(false);
        btnP.add(this.openBtn);
        this.add(dataLenP);
        this.add(fileNameP);
        this.add(progressP);
        this.add(btnP);
        this.readBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordReadDialog.this.bar.setVisible(true);
                BleClient mClient = RecordReadDialog.this.ag.getClient();
                if (mClient != null) {
                    mClient.preSetFileName(RecordReadDialog.this.fileNameLbl.getText().trim());
                    mClient.writeCmd_ReadOfflineData();
                }
            }
        });
        this.openBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RecordReadDialog.this.csvPath != null && RecordReadDialog.this.csvPath != "") {
                    File f = new File(RecordReadDialog.this.csvPath);
                    try {
                        Desktop.getDesktop().open(f.getParentFile());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    System.err.println("err csvPath");
                }
            }
        });
    }

    public void showDlg() {
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new RecordReadDialog(null).showDlg();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pn = evt.getPropertyName();
        Object o = evt.getNewValue();
        if (o == null) {
            return;
        }
        if (pn.equals("offlineDataSize.broadcast")) {
            int size = (Integer)o;
            this.dataLenLbl.setText(String.valueOf(size));
            this.readBtn.setEnabled(true);
            this.bar.setMaximum(size);
        } else if (pn.equals("offlineTransmitProgress.broadcast")) {
            int max;
            int step = (Integer)o;
            int progress = this.bar.getValue() + step;
            if (progress > (max = this.bar.getMaximum())) {
                progress = max;
            }
            String formatStr = StringRes.getString("recordReadDlg.progressBytes");
            this.bar.setString(String.format(formatStr, progress));
            this.bar.setValue(progress);
        } else if (pn.equals("offlineTransmitEnd.broadcast")) {
            this.csvPath = (String)o;
            this.openBtn.setVisible(true);
            this.readBtn.setVisible(false);
        }
    }
}

