/*
 * Decompiled with CFR 0.152.
 */
package frame;

import control.DeviceInitResultListener;
import control.Global;
import control.MainControl;
import frame.AboutDlg;
import frame.PortSettingDlg;
import frame.RecordReadDialog;
import frame.RecordSetDialog;
import frame.ScanDialog;
import frame.i18n.StringRes;
import frame.view.ChartPage;
import frame.view.MultiListItem;
import frame.view.MultiPage;
import frame.view.SinglePage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.BleSlaveManager;
import storeroom.draw.Draw;
import storeroom.util.CTimer;

public class MainFrame
extends JFrame
implements PropertyChangeListener {
    BleAgent ag;
    DeviceInitResultListener initListener;
    CTimer ti = new CTimer();
    Class mContext = MainFrame.class;
    Dimension pageSize = new Dimension(80, 40);
    Dimension funcSize = new Dimension(70, 70);
    private JPanel centerPane;
    private MultiPage mp;
    private SinglePage sp;
    private ChartPage cp;
    private ScanDialog scanDialog;
    JPanel e_btnPane;
    JPanel s_cmdPane;
    JButton addBtn;
    private final int ON_SINGLE = 1;
    private final int ON_MULTI = 2;
    private final int ON_CHART = 3;
    private CardLayout c = new CardLayout();

    private void switchPagesLayout(int pageStatus) {
        switch (pageStatus) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.cp.initChartListModel();
                this.cp.updateDeviceList();
                this.cp.updateDataList();
            }
        }
        boolean visible = pageStatus != 3;
        this.e_btnPane.setVisible(visible);
        this.s_cmdPane.setVisible(visible);
        this.c.show(this.centerPane, String.valueOf(pageStatus));
    }

    public MainFrame() {
        super(StringRes.getString("title.mainFrame"));
        this.setSize(new Dimension(850, 576));
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        JPanel w_btnPane = this.initWestPane();
        JPanel center_Pane = this.initCenterPane();
        this.initEastPane();
        this.initSouthPane(18);
        this.add((Component)w_btnPane, "West");
        this.add((Component)center_Pane, "Center");
        this.add((Component)this.e_btnPane, "East");
        this.add((Component)this.s_cmdPane, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.ag.release();
                Global.saveInstance();
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                System.err.println("System.exit(0)");
                System.exit(0);
            }
        });
        this.ag = Platform.getBle();
        this.ag.broadcast.addProperty(this);
        this.initListener = new DeviceInitResultListener(this);
        new PortSettingDlg(this.initListener);
    }

    private JPanel initWestPane() {
        JPanel p1 = new JPanel();
        JButton btnSingle = Draw.createIconBtn(this.mContext, "/storeroom/draw/pageSingle");
        btnSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.switchPagesLayout(1);
            }
        });
        this.addToCenter(p1, btnSingle);
        JPanel p2 = new JPanel();
        JButton btnMulti = Draw.createIconBtn(this.mContext, "/storeroom/draw/pageMulti");
        btnMulti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.switchPagesLayout(2);
            }
        });
        this.addToCenter(p2, btnMulti);
        JPanel p3 = new JPanel();
        JButton btnList = Draw.createIconBtn(this.mContext, "/storeroom/draw/pageChart");
        btnList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.switchPagesLayout(3);
            }
        });
        this.addToCenter(p3, btnList);
        JPanel pages = new JPanel();
        pages.setLayout(new GridLayout(3, 1));
        pages.add(p1);
        pages.add(p2);
        pages.add(p3);
        return pages;
    }

    private void addToCenter(JPanel container, Component centerObj) {
        container.setLayout(new BorderLayout());
        JLabel e1 = new JLabel(" ");
        JLabel e2 = new JLabel(" ");
        e1.setPreferredSize(this.pageSize);
        e2.setPreferredSize(this.pageSize);
        container.add((Component)e1, "North");
        container.add(centerObj, "Center");
        container.add((Component)e2, "South");
    }

    private JPanel initCenterPane() {
        this.centerPane = new JPanel();
        this.mp = new MultiPage();
        this.sp = new SinglePage();
        this.cp = new ChartPage();
        this.cp.setWinContext(this.getOwner());
        this.centerPane.setLayout(this.c);
        this.centerPane.add((Component)this.mp.getContent(), String.valueOf(2));
        this.centerPane.add((Component)this.sp.getContent(), String.valueOf(1));
        this.centerPane.add((Component)this.cp, String.valueOf(3));
        return this.centerPane;
    }

    private void initEastPane() {
        JPanel p1 = new JPanel();
        this.addBtn = Draw.createIconBtn(this.mContext, "/storeroom/draw/func_add");
        this.addBtn.setEnabled(false);
        this.addBtn.setPreferredSize(this.funcSize);
        p1.add(this.addBtn);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.scanDialog = ScanDialog.getInstance(MainFrame.this);
                MainFrame.this.scanDialog.showDlg();
            }
        });
        JLabel gap = new JLabel("");
        JLabel gap2 = new JLabel("");
        JPanel p2 = new JPanel();
        JButton voiceBtn = Draw.createBtn(this.mContext, "/storeroom/draw/func_offlineSet");
        voiceBtn.setPreferredSize(this.funcSize);
        p2.add(voiceBtn);
        JPanel p3 = new JPanel();
        JButton recordBtn = Draw.createBtn(this.mContext, "/storeroom/draw/func_offlineRead");
        recordBtn.setPreferredSize(this.funcSize);
        p3.add(recordBtn);
        JPanel p4 = new JPanel();
        JButton otherBtn = Draw.createIconBtn(this.mContext, "/storeroom/draw/func_more");
        otherBtn.setPreferredSize(this.funcSize);
        p4.add(otherBtn);
        JPanel p5 = new JPanel();
        JButton aboutBtn = Draw.createBtn(this.mContext, "/storeroom/draw/func_info");
        aboutBtn.setPreferredSize(this.funcSize);
        p5.add(aboutBtn);
        JPanel funcBtns = new JPanel();
        funcBtns.setLayout(new GridLayout(6, 1));
        funcBtns.add(p1);
        funcBtns.add(gap);
        funcBtns.add(gap2);
        funcBtns.add(p2);
        funcBtns.add(p3);
        funcBtns.add(p5);
        voiceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordSetDialog.getInstance(MainFrame.this).showDlg();
            }
        });
        recordBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordReadDialog.getInstance(MainFrame.this).showDlg();
            }
        });
        aboutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDlg.getInstance(MainFrame.this).show();
            }
        });
        this.e_btnPane = funcBtns;
    }

    private JPanel initSouthPane_Bt() {
        JLabel e1 = new JLabel(" ");
        JButton p1 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_hold");
        JButton p2 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_sel");
        JButton p3 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_range");
        JButton p4 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_duty");
        JButton p5 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_max");
        JButton p6 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_bt");
        JLabel e2 = new JLabel(" ");
        JPanel cmdBtns = new JPanel();
        cmdBtns.setLayout(new GridLayout(1, 9));
        cmdBtns.add(e1);
        this.addNlistenning(cmdBtns, p1, 3);
        this.addNlistenning(cmdBtns, p2, 1);
        this.addNlistenning(cmdBtns, p3, 2);
        this.addNlistenning(cmdBtns, p4, 5);
        this.addNlistenning(cmdBtns, p5, 6);
        this.addNlistenning(cmdBtns, p6, 4);
        cmdBtns.add(e2);
        return cmdBtns;
    }

    private JPanel initSouthPane_OWSeries() {
        JLabel e1 = new JLabel(" ");
        JButton p2 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_sel");
        JButton p3 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_range");
        JButton p4 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_duty2");
        JButton p5 = Draw.createIconBtn(this.mContext, "/storeroom/draw/btn_hold2");
        JLabel e2 = new JLabel(" ");
        JPanel cmdBtns = new JPanel();
        cmdBtns.setLayout(new GridLayout(1, 6));
        cmdBtns.add(e1);
        this.addNlistenning(cmdBtns, p2, 1);
        this.addNlistenning(cmdBtns, p3, 2);
        this.addNlistenning(cmdBtns, p4, 5);
        this.addNlistenning(cmdBtns, p5, 3);
        cmdBtns.add(e2);
        return cmdBtns;
    }

    private void addNlistenning(JPanel parent, JButton btn, final int btnId) {
        btn.setPreferredSize(new Dimension(100, 55));
        parent.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MainFrame.this.ti.start();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MainFrame.this.ti.stop();
                long gap = MainFrame.this.ti.measureInSecond();
                boolean isLongPress = gap > 2L;
                BleClient mClient = BleSlaveManager.getSelectedClient();
                switch (btnId) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        MainControl.cWriteCmd(mClient, (byte)btnId, isLongPress);
                        break;
                    }
                }
            }
        });
    }

    public void initSouthPane(int seriesId) {
        if (this.s_cmdPane != null) {
            this.remove(this.s_cmdPane);
        }
        this.s_cmdPane = null;
        this.s_cmdPane = seriesId == 18 || seriesId == 20 || seriesId == 55 ? this.initSouthPane_OWSeries() : this.initSouthPane_Bt();
        this.add((Component)this.s_cmdPane, "South");
        this.validate();
    }

    public void addItem(MultiListItem mit, MultiListItem sit) {
        this.mp.add(mit.doMultiPageLayout());
        this.sp.add(sit.doSinglePageLayout());
        this.centerPane.repaint();
    }

    public void removeItem(MultiListItem mit, MultiListItem sit) {
        if (mit != null) {
            this.mp.remove(mit);
        }
        if (sit != null) {
            this.sp.remove(sit);
        }
        this.centerPane.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pn = evt.getPropertyName();
        Object o = evt.getNewValue();
        if (o == null) {
            return;
        }
        if (pn.equals("DeviceInitResult.broadcast")) {
            boolean result = (Boolean)o;
            if (result) {
                this.initListener.setInitResult(result);
                this.addBtn.setEnabled(true);
            }
        } else if (pn.equals("AlreadyPerformingTheTask.broadcast")) {
            JOptionPane.showMessageDialog(this, String.valueOf(StringRes.getString("scanDlg.hadConnected")) + "\nSTATUS:Already Performing That Task");
        }
    }
}

