/*
 * Decompiled with CFR 0.152.
 */
package control;

import frame.i18n.StringRes;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import storeroom.util.Gsons;

public class Global {
    private static Global g;
    private static File conf;
    public Locale locale = Locale.ENGLISH;
    public Locale[] localeList = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE};
    public String[] localeStrs = new String[]{"English", StringRes.getString("aboutDlg.cn")};

    static {
        conf = new File("conf", "pref.json");
    }

    public static Global getInstance() {
        if (g == null) {
            g = Global.load();
        }
        return g;
    }

    private static Global load() {
        Global g;
        if (!conf.exists()) {
            try {
                conf.getParentFile().mkdirs();
                conf.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return (g = Gsons.load(conf, Global.class)) == null ? new Global() : g;
    }

    public static void saveInstance() {
        if (g != null) {
            Gsons.persist(conf, g);
        }
    }

    public void setDefaultLocale() {
        Locale.setDefault(this.locale);
        StringRes.update();
    }

    public int getLocaleIdx() {
        int i = 0;
        while (i < this.localeList.length) {
            if (this.locale.equals(this.localeList[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setLocale(int idx) {
        if (idx < 0 && idx > this.localeList.length) {
            return;
        }
        this.locale = this.localeList[idx];
    }

    public String debug() {
        String s = this.locale.getDisplayName();
        return s;
    }
}

