/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.AddDataThread;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import kernal.BleClient;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import model.chartModel.CreateJChartLine;
import org.jfree.chart.ChartPanel;
import org.jfree.data.xy.XYSeries;

public class ChartControl {
    public static final String DEVICE_NAME = "devInfo_name";
    public static final String DEVICE_ADDRESS = "devInfo_addr";
    private final String TAG = "ChartControl";
    private final Color defaultColor = Color.YELLOW;
    public final Color[] COLOR_MATRIX = new Color[]{this.defaultColor, Color.RED, Color.GREEN, Color.MAGENTA, Color.WHITE};
    private List<HashMap<String, Object>> mSeriesList = new ArrayList<HashMap<String, Object>>();
    private CreateJChartLine jchart = new CreateJChartLine();
    public boolean singletonAllow = false;

    public void keepSingleton(DefaultListModel series, MultimeterReceivedData data) {
        BleClient client;
        int idx = data.Index - 1;
        if (idx >= 0 && idx < series.getSize() && (client = BleSlaveManager.getClient(data.mAddress)) != null) {
            MultimeterReceivedData lastData = client.getReceivedData().get(idx);
            if (!lastData.UnitType.equals(data.UnitType)) {
                client.needSingleton = true;
            }
            if (this.singletonAllow && client.needSingleton) {
                client.needSingleton = false;
                this.clearClient(client);
            }
        }
    }

    public ChartPanel getChartPanel() {
        ChartPanel cp = this.jchart.getChartPanel();
        return cp;
    }

    public void repaintChartPanel() {
        ChartPanel cp = this.getChartPanel();
        if (cp != null) {
            cp.revalidate();
            cp.repaint();
        }
    }

    public void initClientsSeries() {
        ArrayList<BleClient> clientList = BleSlaveManager.getClients();
        if (clientList != null) {
            int i = 0;
            while (i < clientList.size()) {
                BleClient client = (BleClient)clientList.get(i);
                this.initClientDataModel(client);
                ++i;
            }
        }
    }

    public void initClientDataModel(BleClient client) {
        DefaultListModel datalist;
        if (client != null && (datalist = this.getDataModel(client.getAddress())) == null) {
            this.addSeries(client.getAddress());
        }
    }

    public DefaultComboBoxModel loadDeviceListMode() {
        DefaultComboBoxModel<String> deviceListMode = new DefaultComboBoxModel<String>();
        ArrayList<BleClient> clients = BleSlaveManager.getClients();
        for (BleClient c : clients) {
            deviceListMode.addElement(c.getDevName());
        }
        return deviceListMode;
    }

    private boolean addSeries(String address) {
        String seriesTitle;
        if (address == null || this.mSeriesList == null) {
            return false;
        }
        this.MSG_DEBUG("addSeries, address: " + address);
        Color color = this.getColorForSeries();
        if (this.isClientAddress(address)) {
            BleClient client = BleSlaveManager.getClient(address);
            seriesTitle = client != null ? address : address;
        } else {
            int pos = address.lastIndexOf("/");
            seriesTitle = address.substring(pos + 1);
            this.MSG_DEBUG("addSeries, Local File: " + seriesTitle + ", Path: " + address);
        }
        XYSeries series = this.jchart.createXYSeries(seriesTitle);
        DefaultListModel listModel = new DefaultListModel();
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("address", address);
        entry.put("series", series);
        entry.put("color", color);
        entry.put("list_model", listModel);
        this.mSeriesList.add(entry);
        new AddDataThread(this, address).start();
        return true;
    }

    public boolean removeSeries(String address) {
        if (address == null || this.mSeriesList == null) {
            return false;
        }
        this.MSG_DEBUG("removeSeries, address: " + address);
        int i = 0;
        while (i < this.mSeriesList.size()) {
            HashMap<String, Object> entry = this.mSeriesList.get(i);
            String addr = (String)entry.get("address");
            if (addr.equals(address)) {
                XYSeries series = (XYSeries)entry.get("series");
                this.jchart.removeSeries(series);
                DefaultListModel datalist = (DefaultListModel)entry.get("list_model");
                datalist.clear();
                this.repaintChartPanel();
                this.mSeriesList.remove(i);
                break;
            }
            ++i;
        }
        return true;
    }

    public DefaultListModel getDataModel(String clientAddress) {
        if (clientAddress == null || this.mSeriesList == null) {
            return null;
        }
        int i = 0;
        while (i < this.mSeriesList.size()) {
            HashMap<String, Object> entry = this.mSeriesList.get(i);
            String address = (String)entry.get("address");
            if (address.equals(clientAddress)) {
                DefaultListModel datalist = (DefaultListModel)entry.get("list_model");
                return datalist;
            }
            ++i;
        }
        this.MSG_ERROR("getDataList, Not Found, client: " + clientAddress);
        return null;
    }

    public XYSeries getXYSeries(String clientAddress) {
        if (clientAddress == null || this.mSeriesList == null) {
            return null;
        }
        int i = 0;
        while (i < this.mSeriesList.size()) {
            HashMap<String, Object> entry = this.mSeriesList.get(i);
            String address = (String)entry.get("address");
            if (address.equals(clientAddress)) {
                XYSeries series = (XYSeries)entry.get("series");
                return series;
            }
            ++i;
        }
        this.MSG_ERROR("getSeries, Not Found, client: " + clientAddress);
        return null;
    }

    private Color getColorForSeries() {
        if (this.mSeriesList == null) {
            return this.defaultColor;
        }
        int i = 0;
        while (i < this.COLOR_MATRIX.length) {
            int j = 0;
            j = 0;
            while (j < this.mSeriesList.size()) {
                HashMap<String, Object> entry = this.mSeriesList.get(j);
                Color color = (Color)entry.get("color");
                if (color == this.COLOR_MATRIX[i]) break;
                ++j;
            }
            if (j == this.mSeriesList.size()) {
                return this.COLOR_MATRIX[i];
            }
            ++i;
        }
        return this.defaultColor;
    }

    public boolean isClientAddress(String address) {
        if (address == null) {
            return false;
        }
        return !address.endsWith(".csv");
    }

    public String getFormateData(MultimeterReceivedData data) {
        String gap = "\t       ";
        String value = String.valueOf(data.Index) + gap + data.Func + gap + data.ValueString + "  " + data.Unit + gap + data.Time;
        return value;
    }

    public boolean saveReceiveData(BleClient c) {
        if (c != null) {
            c.saveReceivedData();
            c.clearReceivedData();
            return true;
        }
        return false;
    }

    public boolean clearClient(BleClient c) {
        if (c != null) {
            DefaultListModel datalist;
            String address = c.getAddress();
            XYSeries series = this.getXYSeries(address);
            if (series != null) {
                series.clear();
            }
            if ((datalist = this.getDataModel(address)) != null) {
                datalist.clear();
            }
            c.clearReceivedData();
            return true;
        }
        return false;
    }

    public void setLegendTitle(XYSeries series, String s) {
        String devName = series.getDescription();
        series.setKey((Comparable)((Object)(String.valueOf(devName) + "(" + s + ")")));
    }

    private void MSG_ERROR(String msg) {
        System.err.println("[ ChartControl ] :: Error :: " + msg);
    }

    private void MSG_DEBUG(String msg) {
        System.out.println("dbg[ ChartControl ] $$$:: " + msg);
    }
}

