/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.ChartControl;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.swing.DefaultListModel;
import kernal.BleClient;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import org.jfree.data.xy.XYSeries;

class AddDataThread
extends Thread {
    private final ChartControl chartCtr;
    private String mAddress;
    private String TAG = "AddDataThread";
    private static final boolean INFO = true;

    public AddDataThread(ChartControl cc, String address) {
        this.chartCtr = cc;
        this.MSG_INFO("Create AddDataThread, Address: " + address);
        this.mAddress = address;
    }

    @Override
    public void run() {
        this.MSG_INFO("run, Begin add data, address: " + this.mAddress);
        this.setName("AddDataThread - " + this.mAddress);
        XYSeries series = this.chartCtr.getXYSeries(this.mAddress);
        DefaultListModel datalist = this.chartCtr.getDataModel(this.mAddress);
        if (datalist == null) {
            this.MSG_ERROR("run, series/datalist/adapter not found");
            return;
        }
        if (this.chartCtr.isClientAddress(this.mAddress)) {
            BleClient client = BleSlaveManager.getClient(this.mAddress);
            if (client != null) {
                List<MultimeterReceivedData> receivedDataList = client.getReceivedData();
                int i = 0;
                int len = receivedDataList.size();
                while (i < len) {
                    MultimeterReceivedData data = receivedDataList.get(i);
                    series.add((double)data.Index, data.Value);
                    datalist.addElement(this.chartCtr.getFormateData(data));
                    ++i;
                }
            }
        } else {
            this.openLocalFile2(this.mAddress, datalist);
        }
    }

    void openLocalFile2(String filePath, DefaultListModel datalist) {
        if (!filePath.endsWith(".csv")) {
            return;
        }
        try {
            BufferedReader bufr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "utf-16"));
            String line = null;
            while ((line = bufr.readLine()) != null) {
                if (this.parseLineData(line, datalist)) continue;
            }
            bufr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean parseLineData(String line, DefaultListModel datalist) {
        String UnitString;
        String ValueString;
        String FuncString;
        String[] columns = line.split(",");
        String TimeString = "";
        String DateString = "";
        String IndexString = columns[0];
        if (columns.length == 6) {
            FuncString = columns[1];
            ValueString = columns[2];
            UnitString = columns[3];
            TimeString = columns[4];
            DateString = columns[5];
        } else if (columns.length == 5) {
            FuncString = columns[1];
            ValueString = columns[2];
            UnitString = columns[3];
            TimeString = columns[4];
        } else if (columns.length == 4) {
            FuncString = columns[1];
            ValueString = columns[2];
            UnitString = columns[3];
        } else if (columns.length == 3) {
            FuncString = "";
            ValueString = columns[1];
            UnitString = columns[2];
        } else {
            this.MSG_ERROR("Unexpected line, column: " + columns.length + ", line: " + line);
            return false;
        }
        int Index = Integer.parseInt(IndexString);
        try {
            Double.parseDouble(ValueString);
        }
        catch (Exception exception) {}
        MultimeterReceivedData data = new MultimeterReceivedData();
        data.Index = Index;
        data.Func = FuncString;
        data.ValueString = ValueString;
        data.Unit = UnitString;
        data.Time = TimeString;
        data.Date = DateString;
        datalist.addElement(this.chartCtr.getFormateData(data));
        return true;
    }

    private void MSG_ERROR(String msg) {
        System.err.println("[ Multimeter ][ " + this.TAG + " ] :: Error :: " + msg);
    }

    private void MSG_INFO(String msg) {
        System.out.println("[ " + this.TAG + " ] $$$:: " + msg);
    }
}

