/*
 * Decompiled with CFR 0.152.
 */
package checkBLEFunc;

import checkBLEFunc.TransmitBleCmdHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kernal.BleClient;
import model.BleSlaveManager;

public class TransmitBleDialog
extends JDialog {
    private static TransmitBleDialog dlg;
    JLabel addr1;
    JLabel addr2;
    JLabel addr3;
    JLabel msg1;
    JLabel msg2;
    JLabel msg3;
    TransmitBleCmdHandler t1;
    TransmitBleCmdHandler t2;
    TransmitBleCmdHandler t3;
    Dimension labd = new Dimension(110, 25);

    public static TransmitBleDialog getInstance(JFrame main) {
        if (dlg == null) {
            dlg = new TransmitBleDialog(main);
        }
        return dlg;
    }

    private TransmitBleDialog(JFrame main) {
        super(main);
        this.setTitle("PC BLE IO");
        this.setSize(new Dimension(500, 136));
        this.setVisible(true);
        this.add((Component)this.initNorthPane(), "North");
        this.add((Component)this.initCenterPane(), "Center");
        this.add((Component)this.initSouthPane(), "South");
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TransmitBleDialog.this.t1 != null) {
                    TransmitBleDialog.this.t1.onClose = true;
                    TransmitBleDialog.this.t1.serialPort.close();
                }
                if (TransmitBleDialog.this.t2 != null) {
                    TransmitBleDialog.this.t2.onClose = true;
                    TransmitBleDialog.this.t2.serialPort.close();
                }
                if (TransmitBleDialog.this.t3 != null) {
                    TransmitBleDialog.this.t3.onClose = true;
                    TransmitBleDialog.this.t3.serialPort.close();
                }
                TransmitBleDialog.this.dispose();
                dlg = null;
                System.out.println("TransmitBleDialogClosing");
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }
        });
        JLabel[] addrs = new JLabel[]{this.addr1, this.addr2, this.addr3};
        ArrayList<BleClient> slaves = BleSlaveManager.getClients();
        int i = 0;
        while (i < slaves.size()) {
            if (i > 2) break;
            addrs[i].setText(slaves.get(i).getAddress());
            ++i;
        }
    }

    private JPanel initNorthPane() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(3));
        this.addr1 = new JLabel("Disconnected");
        this.addr1.setPreferredSize(this.labd);
        p.add(this.addr1);
        final JButton open1 = new JButton("open1");
        p.add(open1);
        JButton close1 = new JButton("close1");
        p.add(close1);
        this.msg1 = new JLabel();
        p.add(this.msg1);
        open1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                open1.setEnabled(false);
                String dest = TransmitBleDialog.this.addr1.getText();
                if (!dest.equals("Disconnected")) {
                    TransmitBleDialog.this.t1 = new TransmitBleCmdHandler(dest, new PI(TransmitBleDialog.this){

                        @Override
                        public void updateInput(String s) {
                            (this).TransmitBleDialog.this.msg1.setText(s);
                        }

                        @Override
                        public void updateOutput(String s) {
                            (this).TransmitBleDialog.this.msg1.setText(s);
                        }
                    });
                    TransmitBleDialog.this.t1.onClose = false;
                    TransmitBleDialog.this.t1.startTransmit("COM101");
                    open1.setText("COM101");
                }
            }
        });
        close1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                open1.setEnabled(true);
                if (TransmitBleDialog.this.t1 != null) {
                    TransmitBleDialog.this.t1.onClose = true;
                    TransmitBleDialog.this.t1.serialPort.close();
                    open1.setText("open1");
                }
            }
        });
        return p;
    }

    private JPanel initCenterPane() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(3));
        this.addr2 = new JLabel("Disconnected");
        this.addr2.setPreferredSize(this.labd);
        p.add(this.addr2);
        final JButton open2 = new JButton("open2");
        p.add(open2);
        JButton close2 = new JButton("close2");
        p.add(close2);
        this.msg2 = new JLabel();
        p.add(this.msg2);
        open2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                open2.setEnabled(false);
                String dest = TransmitBleDialog.this.addr2.getText();
                if (!dest.equals("Disconnected")) {
                    TransmitBleDialog.this.t2 = new TransmitBleCmdHandler(dest, new PI(TransmitBleDialog.this){

                        @Override
                        public void updateInput(String s) {
                            (this).TransmitBleDialog.this.msg2.setText(s);
                        }

                        @Override
                        public void updateOutput(String s) {
                            (this).TransmitBleDialog.this.msg2.setText(s);
                        }
                    });
                    TransmitBleDialog.this.t2.onClose = false;
                    TransmitBleDialog.this.t2.startTransmit("COM103");
                    open2.setText("COM103");
                }
            }
        });
        close2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                open2.setEnabled(true);
                if (TransmitBleDialog.this.t2 != null) {
                    TransmitBleDialog.this.t2.onClose = true;
                    TransmitBleDialog.this.t2.serialPort.close();
                    open2.setText("open2");
                }
            }
        });
        return p;
    }

    private JPanel initSouthPane() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(3));
        this.addr3 = new JLabel("Disconnected");
        this.addr3.setPreferredSize(this.labd);
        p.add(this.addr3);
        final JButton open3 = new JButton("open3");
        p.add(open3);
        JButton close3 = new JButton("close3");
        p.add(close3);
        this.msg3 = new JLabel();
        p.add(this.msg3);
        open3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                open3.setEnabled(false);
                String dest = TransmitBleDialog.this.addr3.getText();
                if (!dest.equals("Disconnected")) {
                    TransmitBleDialog.this.t3 = new TransmitBleCmdHandler(dest, new PI(TransmitBleDialog.this){

                        @Override
                        public void updateInput(String s) {
                            (this).TransmitBleDialog.this.msg3.setText(s);
                        }

                        @Override
                        public void updateOutput(String s) {
                            (this).TransmitBleDialog.this.msg3.setText(s);
                        }
                    });
                    TransmitBleDialog.this.t3.onClose = false;
                    TransmitBleDialog.this.t3.startTransmit("COM105");
                    open3.setText("COM105");
                }
            }
        });
        close3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                open3.setEnabled(true);
                if (TransmitBleDialog.this.t3 != null) {
                    TransmitBleDialog.this.t3.onClose = true;
                    TransmitBleDialog.this.t3.serialPort.close();
                    open3.setText("open3");
                }
            }
        });
        return p;
    }

    public static void main(String[] args) {
        TransmitBleDialog f = new TransmitBleDialog(null);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.pack();
    }

    class PI
    implements PP {
        PI() {
        }

        @Override
        public void updateInput(String s) {
        }

        @Override
        public void updateOutput(String s) {
        }
    }

    public static interface PP {
        public void updateInput(String var1);

        public void updateOutput(String var1);
    }
}

